/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeHelper;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.SplitRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class SplitRecipeHelperBuilder {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private SplitRecipeService splitService;
    private final JobActivity activity;
    private final Dataset inputDataset;
    private final SplitRecipePayloadParams params;
    private final boolean lowerCaseColumns;
    private final SQLDialect dialect;
    private long totalRecordsWithFilters;

    public SplitRecipeHelperBuilder(JobActivity activity, SplitRecipePayloadParams params, boolean lowerCaseColumns, SQLDialect dialect) throws IOException {
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = activity;
        this.params = params;
        this.lowerCaseColumns = lowerCaseColumns;
        this.dialect = dialect;
        RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        FlowDataset source = subgraph.getSourceDatasets().get(0);
        this.inputDataset = source.getMandatory(this.datasetsDAO);
    }

    public SplitRecipeHelper build() throws IOException {
        Schema baseOutputSchema = this.splitService.getBaseOutputSchema(this.inputDataset, this.params);
        FlowRecipe recipe = ((RecipeRunnableSubgraph)this.activity.getSubgraph()).getRecipe();
        SplitRecipeHelper splitHelper = new SplitRecipeHelper(this.activity, this.inputDataset, this.params, recipe.getProjectKey());
        if (this.params.mode == SplitRecipePayloadParams.Mode.CENTILE) {
            splitHelper.setTotalRecordsWithFilters(this.totalRecordsWithFilters);
            splitHelper.setShouldCommentCentileQuery(false);
        }
        splitHelper.setLowerCaseColumns(this.lowerCaseColumns);
        splitHelper.setBaseOutputSchema(baseOutputSchema);
        splitHelper.computeEffectiveConditions(this.dialect);
        return splitHelper;
    }

    void setTotalRecordsWithFilters(long totalRecordsWithFilters) {
        if (this.params.mode != SplitRecipePayloadParams.Mode.CENTILE) {
            throw new IllegalStateException("Total records with filters is only used in CENTILE mode");
        }
        this.totalRecordsWithFilters = totalRecordsWithFilters;
    }
}

