/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pdep;

import com.dataiku.dip.dataflow.pdep.AbstractTimeEvaluator;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class CurrentMonthEvaluator
extends AbstractTimeEvaluator {
    private Date flowEpoch;

    public CurrentMonthEvaluator(Set<Date> blacklist, Date flowEpoch) {
        super(blacklist);
        this.flowEpoch = flowEpoch;
    }

    @Override
    public List<DimensionValue> getDependent(DimensionValue target, Dimension srcDim) {
        Preconditions.checkArgument((boolean)(srcDim instanceof TimeDimension), (Object)"Partitioning dimension is not a time dimension");
        Calendar initialCal = this.getDayLevelCalendar(target);
        Calendar movingCal = DKUtils.getUTCCalendar();
        movingCal.setTime(initialCal.getTime());
        ArrayList<DimensionValue> ov = new ArrayList<DimensionValue>();
        while (true) {
            if (movingCal.getTime().before(this.flowEpoch)) {
                System.out.println("flowEpoch " + String.valueOf(this.flowEpoch) + " reached at " + String.valueOf(movingCal.getTime()));
                break;
            }
            if (movingCal.get(1) != initialCal.get(1) || movingCal.get(2) != initialCal.get(2)) {
                System.out.println("Reached beginning at " + String.valueOf(movingCal.getTime()));
                break;
            }
            if (!this.isBlacklisted(movingCal.getTime())) {
                ov.add((DimensionValue)CurrentMonthEvaluator.getValueFromCalendar(movingCal, (TimeDimension)srcDim));
            }
            movingCal.add(5, -1);
        }
        return ov;
    }
}

