/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.sort;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datalayer.sort.SortedRowsIterator;
import com.dataiku.dip.datalayer.sort.SortingChunk;
import com.dataiku.dip.datalayer.sort.SpilledRowsStorage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class Sorter
implements ProcessorOutput {
    private final List<SortSpec> specs;
    private final Schema schema;
    private final Map<String, SchemaColumn> columnsByName;
    private final List<SortingChunk> chunks = Lists.newArrayList();
    private final MergeSortParams mergeSortParams;
    private final SpilledRowsStorage storage;
    private final RowsComparator inputSorter;
    private final ColumnFactory outputCf;
    private final RowFactory outputRf;
    private long chunkedCount = 0L;
    private RowsComparator outputSorter;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sorter");

    public Sorter(List<SortSpec> specs, Schema schema, ColumnFactory inputCf, SpilledRowsStorage storage, RowFactory outputRf, ColumnFactory outputCf, MergeSortParams mergeSortParams) {
        this.specs = specs;
        this.schema = schema;
        this.storage = storage;
        this.outputRf = outputRf;
        this.outputCf = outputCf;
        this.mergeSortParams = mergeSortParams;
        this.columnsByName = Maps.newHashMap();
        for (SchemaColumn column : this.schema.getColumns()) {
            this.columnsByName.put(column.getName(), column);
        }
        for (SortSpec spec : specs) {
            if (!this.columnsByName.containsKey(spec.column)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCOMPATIBLE_SCHEMA, "Missing column '" + spec.column + "'");
            }
            spec.schemaColumn = this.columnsByName.get(spec.column);
            spec.factoryColumn = inputCf.column(spec.column);
        }
        this.inputSorter = new RowsComparator(this.specs, RowsComparator.NullsOrdering.AUTO);
    }

    private SortingChunk newChunk() {
        SortingChunk chunk = new SortingChunk(this.inputSorter, this.storage, this.chunkedCount);
        this.chunks.add(chunk);
        return chunk;
    }

    private SortingChunk getChunk(Row row) throws Exception {
        if (this.chunks.size() == 0) {
            return this.newChunk();
        }
        SortingChunk lastChunk = this.chunks.get(this.chunks.size() - 1);
        if (lastChunk.used() < this.mergeSortParams.maxChunkSize) {
            return lastChunk;
        }
        lastChunk.spill();
        return this.newChunk();
    }

    public void emitRow(Row row) throws Exception {
        this.getChunk(row).emitRow(row);
        ++this.chunkedCount;
    }

    public void lastRowEmitted() throws Exception {
        for (SortingChunk chunk : this.chunks) {
            chunk.lastRowEmitted();
        }
        ArrayList outputSpecs = Lists.newArrayList();
        for (SortSpec spec : this.specs) {
            SortSpec outputSpec = new SortSpec(spec);
            outputSpec.factoryColumn = this.outputCf.column(spec.column);
            outputSpecs.add(outputSpec);
        }
        this.outputSorter = new RowsComparator(outputSpecs, RowsComparator.NullsOrdering.AUTO);
    }

    public void cancel() throws Exception {
        for (SortingChunk chunk : this.chunks) {
            chunk.cancel();
        }
    }

    public SortedRowsIterator read() throws IOException {
        return new SortedRowsIterator(this.chunks, this.storage, this.outputRf, this.outputCf, this.outputSorter);
    }

    public SortedRowsIterator readWithRank(Comparator<NumberedRow> rankComparator) throws IOException {
        return new SortedRowsIterator(this.chunks, this.storage, this.outputRf, this.outputCf, this.outputSorter, rankComparator);
    }

    public boolean emitOnlyValidRowForColumn(Row row, String columnName, boolean isNumeric) throws Exception {
        Column orderColumn = this.outputCf.getColumn(columnName);
        if (isNumeric) {
            if (!Double.isNaN(row.getAsDoubleOrNaN(orderColumn))) {
                this.emitRow(row);
                return true;
            }
        } else {
            String strval = row.get(orderColumn);
            if (strval != null && !strval.isEmpty()) {
                this.emitRow(row);
                return true;
            }
        }
        return false;
    }

    public long emitAndCountOnlyValidRowsForColumn(RowInputStream inputStream, String columnName) throws Exception {
        long rowCount = 0L;
        Type orderColumnType = this.schema.getColumn(columnName).getType();
        boolean isNumeric = orderColumnType.isNumeric();
        if (!isNumeric || !orderColumnType.isTemporal()) {
            logger.warn((Object)("Ordering column \"" + columnName + "\" is neither numeric or temporal"));
        }
        Row row = inputStream.next();
        while (row != null) {
            if (this.emitOnlyValidRowForColumn(row, columnName, isNumeric)) {
                ++rowCount;
            }
            row = inputStream.next();
        }
        return rowCount;
    }

    public String stats() {
        return "comparisons=" + this.inputSorter.count;
    }

    public void setMaxMemoryUsed(long size) {
    }

    public static class MergeSortParams {
        public long maxChunkSize = DKUApp.getParams().getLongParam("dku.mergesort.maxChunkSize", 0x8000000L);
        public int chunkReadBufferSize = DKUApp.getParams().getIntParam("dku.mergesort.chunkReadBufferSize", Integer.valueOf(32768));

        public MergeSortParams() {
        }

        public MergeSortParams(long maxChunkSize) {
            this.maxChunkSize = maxChunkSize;
        }
    }

    public static class SortSpec {
        public String column;
        public boolean ascending;
        public transient SchemaColumn schemaColumn;
        public transient Column factoryColumn;

        public SortSpec(String column, boolean ascending) {
            this.column = column;
            this.ascending = ascending;
        }

        public SortSpec(SortSpec o) {
            this.column = o.column;
            this.ascending = o.ascending;
            this.schemaColumn = o.schemaColumn;
            this.factoryColumn = o.factoryColumn;
        }
    }
}

