/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.utils;

import com.dataiku.dip.analysis.ml.MLSparkParams;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.impala.ImpalaExecutor;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeMeta;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeMeta;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLExecutor;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeEngineParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsDAO;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class RecipeCreationUtils {
    private RecipeCreationUtils() {
    }

    public static void makeEqualsOrAllAvailableDep(SerializedRecipe recipe, String inputRole, String inputRef, Dataset inputDataset, Partitionable output) {
        if (inputDataset.getPartitioningSchema().isPartitioned()) {
            PartitioningScheme outputPartitioning = output.getPartitioningSchema();
            SerializedRecipe.RecipeInput input = recipe.getInput(inputRole, inputRef);
            String outputRef = recipe.getSingleOutput((String)"main").ref;
            for (String dimension : inputDataset.getPartitioningSchema().getDimensionNames()) {
                if (outputPartitioning != null && outputPartitioning.getDimensionNamesSet().contains(dimension)) {
                    input.deps.add(new SerializedRecipe.SDep(outputRef, dimension, dimension, "equals"));
                    continue;
                }
                input.deps.add(new SerializedRecipe.SDep(null, dimension, null, "all_available"));
            }
        }
    }

    public static HiveRecipeMeta.HiveRecipeParams setupHiveParams(AuthCtx authCtx, String projectKey, HiveRecipeMeta.HiveRecipeParams params) {
        try {
            HiveSettings hiveSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getHiveSettings();
            SerializedProject.ProjectSettings ps2 = ((ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class)).getMandatoryUnsafe((String)projectKey).settings;
            params.executionEngine = ps2.hiveEngineCreationSettings.useGlobal ? hiveSettings.engineCreationSettings.executionEngine : ps2.hiveEngineCreationSettings.executionEngine;
            return params;
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ImpalaExecutor.ImpalaExecutorParams setupImpalaParams(AuthCtx authCtx, String projectKey, ImpalaExecutor.ImpalaExecutorParams params) {
        try {
            ImpalaSettings is = new ClusterSelector().selectForProject(authCtx, projectKey).getImpalaSettings();
            SerializedProject.ProjectSettings ps2 = ((ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class)).getMandatoryUnsafe((String)projectKey).settings;
            params.forceStreamMode = ps2.impalaEngineCreationSettings.useGlobal ? is.engineCreationSettings.streamMode : ps2.impalaEngineCreationSettings.streamMode;
            return params;
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ImpalaRecipeMeta.ImpalaRecipeParams setupImpalaParams(AuthCtx authCtx, String projectKey, ImpalaRecipeMeta.ImpalaRecipeParams params) {
        try {
            ImpalaSettings is = new ClusterSelector().selectForProject(authCtx, projectKey).getImpalaSettings();
            SerializedProject.ProjectSettings ps2 = ((ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class)).getMandatoryUnsafe((String)projectKey).settings;
            params.runInStreamMode = ps2.impalaEngineCreationSettings.useGlobal ? is.engineCreationSettings.streamMode : ps2.impalaEngineCreationSettings.streamMode;
            return params;
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SparkSQLExecutor.SparkSQLExecutorParams setupSparkEngineParams(AuthCtx authCtx, String projectKey, SparkSQLExecutor.SparkSQLExecutorParams params) {
        try {
            SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
            SparkSettings.GlobalSparkEngineCreationSettings gs = sparkSettings.engineCreationSettings;
            SerializedProject.ProjectSparkEngineCreationSettings ps2 = ((ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class)).getMandatoryUnsafe((String)projectKey).settings.sparkEngineCreationSettings;
            if (ps2.useGlobal) {
                if (StringUtils.isNotBlank((String)gs.executionConfig)) {
                    params.sparkConfig.inheritConf = gs.executionConfig;
                }
                params.executionEngine = gs.executionEngine;
                params.useGlobalMetastore = gs.useGlobalMetastore;
            } else {
                if (StringUtils.isNotBlank((String)ps2.executionConfig)) {
                    params.sparkConfig.inheritConf = ps2.executionConfig;
                }
                params.executionEngine = ps2.executionEngine;
                params.useGlobalMetastore = ps2.useGlobalMetastore;
            }
            return params;
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static MLSparkParams setupMLSparkParams(AuthCtx authCtx, String projectKey, String sparkConfName, Boolean useGlobalMetastore) {
        MLSparkParams params = RecipeCreationUtils.setupMLSparkParams(authCtx, projectKey, new MLSparkParams());
        if (StringUtils.isNotBlank((String)sparkConfName)) {
            params.sparkConf.inheritConf = sparkConfName;
        }
        if (useGlobalMetastore != null) {
            params.sparkUseGlobalMetastore = useGlobalMetastore;
        }
        return params;
    }

    public static MLSparkParams setupMLSparkParams(AuthCtx authCtx, String projectKey, MLSparkParams params) {
        try {
            SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
            SparkSettings.GlobalSparkEngineCreationSettings gs = sparkSettings.engineCreationSettings;
            SerializedProject.ProjectSparkEngineCreationSettings ps2 = ((ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class)).getMandatoryUnsafe((String)projectKey).settings.sparkEngineCreationSettings;
            if (ps2.useGlobal) {
                if (StringUtils.isNotBlank((String)gs.executionConfig)) {
                    params.sparkConf.inheritConf = gs.executionConfig;
                }
                params.sparkExecutionEngine = gs.executionEngine;
                params.sparkUseGlobalMetastore = gs.useGlobalMetastore;
            } else {
                if (StringUtils.isNotBlank((String)ps2.executionConfig)) {
                    params.sparkConf.inheritConf = ps2.executionConfig;
                }
                params.sparkExecutionEngine = ps2.executionEngine;
                params.sparkUseGlobalMetastore = ps2.useGlobalMetastore;
            }
            return params;
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setupShakerRecipeEngineParams(AuthCtx authCtx, String projectKey, ShakerRecipeParams recipeParams) {
        try {
            ClusterSettings clusterSettings = new ClusterSelector().selectForProject(authCtx, projectKey);
            ShakerRecipeParams.ShakerRecipeEngineParams engineParams = recipeParams.engineParams;
            SerializedProject.ProjectSettings projectSettings = ((ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class)).getMandatoryUnsafe((String)projectKey).settings;
            SparkSettings sparkSettings = clusterSettings.getSparkSettings();
            if (projectSettings.sparkEngineCreationSettings.useGlobal) {
                SparkSettings.GlobalSparkEngineCreationSettings gs = sparkSettings.engineCreationSettings;
                if (StringUtils.isNotBlank((String)gs.executionConfig)) {
                    engineParams.spark.sparkConfig.inheritConf = gs.executionConfig;
                }
                engineParams.spark.executionEngine = gs.executionEngine;
                engineParams.spark.useGlobalMetastore = gs.useGlobalMetastore;
            } else {
                SerializedProject.ProjectSparkEngineCreationSettings ps2 = projectSettings.sparkEngineCreationSettings;
                if (StringUtils.isNotBlank((String)ps2.executionConfig)) {
                    engineParams.spark.sparkConfig.inheritConf = ps2.executionConfig;
                }
                engineParams.spark.executionEngine = ps2.executionEngine;
                engineParams.spark.useGlobalMetastore = ps2.useGlobalMetastore;
            }
            HiveSettings hiveSettings = clusterSettings.getHiveSettings();
            if (projectSettings.hiveEngineCreationSettings.useGlobal) {
                HiveSettings.GlobalHiveEngineCreationSettings gs = hiveSettings.engineCreationSettings;
                if (StringUtils.isNotBlank((String)gs.executionConfig)) {
                    engineParams.hive.inheritConf = gs.executionConfig;
                }
                engineParams.hive.executionEngine = gs.executionEngine;
            } else {
                SerializedProject.ProjectHiveEngineCreationSettings ps3 = projectSettings.hiveEngineCreationSettings;
                if (StringUtils.isNotBlank((String)ps3.executionConfig)) {
                    engineParams.hive.inheritConf = ps3.executionConfig;
                }
                engineParams.hive.executionEngine = ps3.executionEngine;
            }
            ImpalaSettings impalaSettings = clusterSettings.getImpalaSettings();
            engineParams.impala.forceStreamMode = projectSettings.impalaEngineCreationSettings.useGlobal ? impalaSettings.engineCreationSettings.streamMode : projectSettings.impalaEngineCreationSettings.streamMode;
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setupSparkSQLRecipeEngineParams(AuthCtx authCtx, String projectKey, SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams recipeParams) {
        try {
            SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
            SparkSettings.GlobalSparkEngineCreationSettings gs = sparkSettings.engineCreationSettings;
            SerializedProject.ProjectSparkEngineCreationSettings ps2 = ((ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class)).getMandatoryUnsafe((String)projectKey).settings.sparkEngineCreationSettings;
            if (ps2.useGlobal) {
                if (StringUtils.isNotBlank((String)gs.executionConfig)) {
                    recipeParams.sparkConfig.inheritConf = gs.executionConfig;
                }
                recipeParams.executionEngine = gs.executionEngine;
                recipeParams.useGlobalMetastore = gs.useGlobalMetastore;
            } else {
                if (StringUtils.isNotBlank((String)ps2.executionConfig)) {
                    recipeParams.sparkConfig.inheritConf = ps2.executionConfig;
                }
                recipeParams.executionEngine = ps2.executionEngine;
                recipeParams.useGlobalMetastore = ps2.useGlobalMetastore;
            }
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setupAbstractSparkRecipeParams(AuthCtx authCtx, String projectKey, AbstractSparkRecipeParams recipeParams) {
        try {
            SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
            SparkSettings.GlobalSparkEngineCreationSettings gs = sparkSettings.engineCreationSettings;
            SerializedProject.ProjectSparkEngineCreationSettings ps2 = ((ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class)).getMandatoryUnsafe((String)projectKey).settings.sparkEngineCreationSettings;
            if (ps2.useGlobal) {
                if (StringUtils.isNotBlank((String)gs.executionConfig)) {
                    recipeParams.sparkConfig.inheritConf = gs.executionConfig;
                }
                recipeParams.executionEngine = gs.executionEngine;
                if (recipeParams instanceof SparkScalaRecipeMeta.SparkScalaRecipeParams) {
                    ((SparkScalaRecipeMeta.SparkScalaRecipeParams)recipeParams).useGlobalMetastore = gs.useGlobalMetastore;
                }
            } else {
                if (StringUtils.isNotBlank((String)ps2.executionConfig)) {
                    recipeParams.sparkConfig.inheritConf = ps2.executionConfig;
                }
                recipeParams.executionEngine = ps2.executionEngine;
                if (recipeParams instanceof SparkScalaRecipeMeta.SparkScalaRecipeParams) {
                    ((SparkScalaRecipeMeta.SparkScalaRecipeParams)recipeParams).useGlobalMetastore = ps2.useGlobalMetastore;
                }
            }
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setupAllEnginesCreationParams(AuthCtx authCtx, String projectKey, VisualSQLRecipeEngineParams engineParams) {
        engineParams.hive = RecipeCreationUtils.setupHiveParams(authCtx, projectKey, engineParams.hive);
        engineParams.impala = RecipeCreationUtils.setupImpalaParams(authCtx, projectKey, engineParams.impala);
        engineParams.sparkSQL = RecipeCreationUtils.setupSparkEngineParams(authCtx, projectKey, engineParams.sparkSQL);
    }

    public static void switchToHiveserverForHiveDataset(Dataset dataset, VisualSQLRecipeEngineParams engineParams) {
        if (DatasetInspector.isHive(dataset)) {
            engineParams.hive.executionEngine = HiveRecipeMeta.HiveExecutionEngine.HIVESERVER2;
        }
    }
}

