/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.experimentsdb;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.experimentsdb.ExperimentsDBDatasetMeta;
import com.dataiku.dip.datasets.experimentsdb.ExperimentsDBDatasetParams;
import com.dataiku.dip.datasets.experimentsdb.ExperimentsDBDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.experimenttracking.ExperimentTrackingInternalDB;
import com.dataiku.dip.experimenttracking.ExperimentTrackingInternalDBNoCreate;
import com.dataiku.dip.experimenttracking.Run;
import com.dataiku.dip.experimenttracking.RunMetric;
import com.dataiku.dip.experimenttracking.RunParam;
import com.dataiku.dip.experimenttracking.RunTag;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ExperimentsDBDatasetHandler
implements RowOrientedDatasetHandler {
    public static final String METRIC_KEY = "metric_key";
    public static final String METRIC_VALUE = "metric_value";
    public static final String METRIC_STEP = "metric_step";
    public static final String METRIC_TIMESTAMP = "metric_timestamp";
    public static final String PARAM_KEY = "param_key";
    public static final String PARAM_VALUE = "param_value";
    public static final String TAG_KEY = "tag_key";
    public static final String TAG_VALUE = "tag_value";
    public static final String METRICS = "metrics";
    public static final String PARAMS = "params";
    public static final String TAGS = "tags";
    @Autowired
    private ExperimentTrackingInternalDBNoCreate experimentTrackingInternalDBNoCreate;
    private final ExperimentsDBDatasetParams params;
    private final Dataset dataset;
    public static final ExperimentsDBDatasetMeta META = new ExperimentsDBDatasetMeta();
    public static final SchemaColumn[] RUN_COLUMNS_LOWERCASE = (SchemaColumn[])Arrays.stream(ExperimentTrackingInternalDB.RUN_COLUMNS).map(column -> {
        SchemaColumn copy = new SchemaColumn(column);
        copy.setName(copy.getName().toLowerCase(Locale.ENGLISH));
        return copy;
    }).toArray(SchemaColumn[]::new);
    private static final Logger logger = Logger.getLogger((String)"dku.datasets.metrics");

    public ExperimentsDBDatasetHandler(Dataset dataset) {
        this.dataset = dataset;
        this.params = dataset.getParamsAs(ExperimentsDBDatasetParams.class);
    }

    private ExperimentTrackingInternalDBNoCreate getExperimentsDB() {
        if (this.experimentTrackingInternalDBNoCreate == null) {
            SpringUtils.getInstance().autowire((Object)this);
        }
        return this.experimentTrackingInternalDBNoCreate;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return META;
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new ExperimentsDBDatasetTestHandler(this);
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException, CodedException, DKUSecurityException {
    }

    @Override
    public String suggestName() {
        switch (this.params.scope) {
            case PROJECT: {
                return "project_experiment_tracking_data";
            }
            case INSTANCE: {
                return "instance_experiment_tracking_data";
            }
        }
        throw new NotImplementedException("Unsupported scope " + String.valueOf((Object)this.params.scope));
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return true;
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return false;
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() throws IOException {
    }

    @Override
    public void createManaged() throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot manage an Experiment Tracking dataset");
    }

    @Override
    public void clearAllData() throws Exception {
        logger.info((Object)"Request to clear an experiment tracking dataset: ignored.");
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        logger.info((Object)"Request to clear partitions of an experiment tracking dataset: ignored.");
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        logger.info((Object)"Request to clear an experiment tracking dataset and its structure: ignored.");
    }

    @Override
    public long getRecords() throws Exception {
        switch (this.params.scope) {
            case PROJECT: {
                List<Run> runs = this.getExperimentsDB().searchRuns_NT(this.dataset.getProjectKey(), this.params.experimentIds, this.params.viewType, this.params.filter, 1000L, this.params.orderBy);
                return runs.size();
            }
        }
        throw new NotImplementedException("Unsupported scope " + String.valueOf((Object)this.params.scope));
    }

    public static Schema getSchema(ExperimentsDBDatasetParams.RetrievalScope scope, ExperimentsDBDatasetParams.Format format) {
        switch (scope) {
            case PROJECT: {
                switch (format) {
                    case LONG: {
                        ArrayList columns = Lists.newArrayList((Object[])RUN_COLUMNS_LOWERCASE);
                        columns.add(new SchemaColumn(METRIC_KEY, Type.STRING));
                        columns.add(new SchemaColumn(METRIC_VALUE, Type.DOUBLE));
                        columns.add(new SchemaColumn(METRIC_STEP, Type.INT));
                        columns.add(new SchemaColumn(METRIC_TIMESTAMP, Type.INT));
                        columns.add(new SchemaColumn(PARAM_KEY, Type.STRING));
                        columns.add(new SchemaColumn(PARAM_VALUE, Type.STRING));
                        columns.add(new SchemaColumn(TAG_KEY, Type.STRING));
                        columns.add(new SchemaColumn(TAG_VALUE, Type.STRING));
                        return new Schema((List)columns, false);
                    }
                    case JSON: {
                        ArrayList columns = Lists.newArrayList((Object[])RUN_COLUMNS_LOWERCASE);
                        columns.add(new SchemaColumn(METRICS, Type.STRING));
                        columns.add(new SchemaColumn(PARAMS, Type.STRING));
                        columns.add(new SchemaColumn(TAGS, Type.STRING));
                        return new Schema((List)columns, false);
                    }
                }
                throw new NotImplementedException("Unsupported format " + String.valueOf((Object)format));
            }
        }
        throw new NotImplementedException("Unsupported scope " + String.valueOf((Object)scope));
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        return this.getRecords();
    }

    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        return DatasetReadiness.ready(null);
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        return new FilterResultWithSplits().withMatchingPartition(new Partition(null)).withSplit((InputSplit)this.getSingleSplit());
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot write on an experiment tracking dataset");
    }

    @Override
    public boolean outputHandlesClear() {
        throw new Error("Cannot write on an experiment tracking dataset");
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        return new MLflowRunsSplit();
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public void close() throws IOException {
    }

    class MLflowRunsSplit
    extends RowsInputSplit {
        MLflowRunsSplit() {
        }

        private void runInfoToRow(ColumnFactory cf, Row r, Run run) {
            r.put(cf.column("RUN_PROJECT_KEY".toLowerCase(Locale.ENGLISH)), ExperimentsDBDatasetHandler.this.dataset.getProjectKey());
            r.put(cf.column("RUN_EXP_ID".toLowerCase(Locale.ENGLISH)), run.info.experimentId);
            r.put(cf.column("RUN_UUID".toLowerCase(Locale.ENGLISH)), run.info.runUuid);
            r.put(cf.column("RUN_START_TIME".toLowerCase(Locale.ENGLISH)), run.info.startTime);
            r.put(cf.column("RUN_END_TIME".toLowerCase(Locale.ENGLISH)), run.info.endTime);
            r.put(cf.column("RUN_USER_ID".toLowerCase(Locale.ENGLISH)), run.info.userId);
            r.put(cf.column("RUN_STATUS".toLowerCase(Locale.ENGLISH)), run.info.status.toString());
            r.put(cf.column("RUN_ARTIFACT_URI".toLowerCase(Locale.ENGLISH)), run.info.artifactUri);
            r.put(cf.column("RUN_LIFECYCLE_STAGE".toLowerCase(Locale.ENGLISH)), run.info.lifecycleStage);
            r.put(cf.column("RUN_ID".toLowerCase(Locale.ENGLISH)), run.info.runId);
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            long rowsPushed = 0L;
            for (SchemaColumn column : ExperimentsDBDatasetHandler.this.dataset.getSchema().getColumns()) {
                cf.column(column.getName());
            }
            block0 : switch (ExperimentsDBDatasetHandler.this.params.scope) {
                case PROJECT: {
                    List<Run> runs = ExperimentsDBDatasetHandler.this.getExperimentsDB().searchRuns_NT(ExperimentsDBDatasetHandler.this.dataset.getProjectKey(), ExperimentsDBDatasetHandler.this.params.experimentIds, ExperimentsDBDatasetHandler.this.params.viewType, ExperimentsDBDatasetHandler.this.params.filter, limit != null ? limit.maxRecords : 0L, ExperimentsDBDatasetHandler.this.params.orderBy);
                    switch (ExperimentsDBDatasetHandler.this.params.format) {
                        case LONG: {
                            Column paramKeyColumn = cf.column(ExperimentsDBDatasetHandler.PARAM_KEY);
                            Column paramValueColumn = cf.column(ExperimentsDBDatasetHandler.PARAM_VALUE);
                            Column metricKeyColumn = cf.column(ExperimentsDBDatasetHandler.METRIC_KEY);
                            Column metricValueColumn = cf.column(ExperimentsDBDatasetHandler.METRIC_VALUE);
                            Column metricStepColumn = cf.column(ExperimentsDBDatasetHandler.METRIC_STEP);
                            Column metricTimestampColumn = cf.column(ExperimentsDBDatasetHandler.METRIC_TIMESTAMP);
                            Column tagKeyColumn = cf.column(ExperimentsDBDatasetHandler.TAG_KEY);
                            Column tagValueColumn = cf.column(ExperimentsDBDatasetHandler.TAG_VALUE);
                            for (Run run : runs) {
                                Row r;
                                for (RunParam p2 : run.data.runParams) {
                                    r = rf.row();
                                    this.runInfoToRow(cf, r, run);
                                    r.put(paramKeyColumn, p2.key);
                                    r.put(paramValueColumn, p2.value);
                                    out.emitRow(r);
                                    if (limit == null || ++rowsPushed != limit.maxRecords) continue;
                                    return rowsPushed;
                                }
                                for (RunMetric m2 : run.data.metrics) {
                                    r = rf.row();
                                    this.runInfoToRow(cf, r, run);
                                    r.put(metricKeyColumn, m2.key);
                                    r.put(metricValueColumn, m2.value);
                                    r.put(metricTimestampColumn, m2.timestamp);
                                    r.put(metricStepColumn, m2.step);
                                    out.emitRow(r);
                                    if (limit == null || ++rowsPushed != limit.maxRecords) continue;
                                    return rowsPushed;
                                }
                                for (RunTag t2 : run.data.runTags) {
                                    r = rf.row();
                                    this.runInfoToRow(cf, r, run);
                                    r.put(tagKeyColumn, t2.key);
                                    r.put(tagValueColumn, t2.value);
                                    out.emitRow(r);
                                    if (limit == null || ++rowsPushed != limit.maxRecords) continue;
                                    return rowsPushed;
                                }
                            }
                            break block0;
                        }
                        case JSON: {
                            Column metricsColumn = cf.column(ExperimentsDBDatasetHandler.METRICS);
                            Column paramsColumn = cf.column(ExperimentsDBDatasetHandler.PARAMS);
                            Column tagsColumn = cf.column(ExperimentsDBDatasetHandler.TAGS);
                            for (Run run : runs) {
                                Row r = rf.row();
                                this.runInfoToRow(cf, r, run);
                                HashMap metricsMap = new HashMap();
                                run.data.metrics.forEach(m -> {
                                    if (!metricsMap.containsKey(m.key)) {
                                        metricsMap.put(m.key, new ArrayList());
                                    }
                                    ((List)metricsMap.get(m.key)).add(new MetricJsonData((RunMetric)m));
                                });
                                r.put(metricsColumn, JSON.json(metricsMap));
                                r.put(paramsColumn, JSON.json(run.data.runParams.stream().collect(Collectors.toMap(p -> p.key, p -> p.value))));
                                r.put(tagsColumn, JSON.json(run.data.runTags.stream().collect(Collectors.toMap(t -> t.key, t -> t.value))));
                                out.emitRow(r);
                                if (limit == null || ++rowsPushed != limit.maxRecords) continue;
                                return rowsPushed;
                            }
                            break block0;
                        }
                        default: {
                            throw new NotImplementedException("Unsupported format " + String.valueOf((Object)ExperimentsDBDatasetHandler.this.params.format));
                        }
                    }
                }
                default: {
                    throw new NotImplementedException("Unsupported scope " + String.valueOf((Object)ExperimentsDBDatasetHandler.this.params.scope));
                }
            }
            return rowsPushed;
        }

        public String getDesc() {
            return "ExperimentsDB_runs";
        }
    }

    public static class MetricJsonData {
        long step;
        long timestamp;
        double value;

        MetricJsonData(RunMetric metric) {
            this.step = metric.step;
            this.timestamp = metric.timestamp;
            this.value = metric.value;
        }
    }
}

