/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.exec.sync.FastpathUtils;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.MetastoreAwareDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.S3DatasetTestHandler;
import com.dataiku.dip.datasets.fs.S3FSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.hadoop.HadoopFlavorUtils;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.regions.RegionUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.s3.model.S3ObjectSummary;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class S3DatasetHandler
extends BlobLikeDatasetHandler<BuiltinFSDatasets.S3DatasetConfig>
implements FSDatasetBrowseService.BrowsableHandler,
MetastoreAwareDatasetHandler {
    private final HDFSInterface hdfsInterface;
    private final PasswordEncryptionService symetricCryptoService;
    private boolean brokenPithosS3 = !ApplicationConfigurator.isInSparkDriver() && ApplicationConfigurator.getProperty((String)"s3.provider", (String)"").equals("pithos");
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.s3");

    public S3DatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
        EC2Connection conn;
        Preconditions.checkNotNull((Object)this.dataset);
        ((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).bucket = VariablesUtils.expand(dataset.getProjectKey(), ((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).bucket);
        ((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).metastoreDatabaseName = VariablesUtils.expand(dataset.getProjectKey(), ((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).metastoreDatabaseName);
        ((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).metastoreTableName = VariablesUtils.expand(dataset.getProjectKey(), ((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).metastoreTableName);
        this.symetricCryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        try {
            conn = this.getConnection();
        }
        catch (Exception e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Failed to get S3 connection", (Throwable)e);
        }
        this.hdfsInterface = conn.params.hdfsInterface;
        if (this.hdfsInterface == null) {
            throw ErrorContext.iae((String)"Invalid HDFS interface for S3 connection");
        }
        if (this.brokenPithosS3) {
            logger.info((Object)"Using Pithos S3 implementation");
        }
    }

    @Override
    public void checkConfiguration() throws IOException, DKUSecurityException, CodedException {
        if (StringUtils.isBlank((String)this.getBucket())) {
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Invalid S3 dataset configuration: no bucket specified");
        }
        super.checkConfiguration();
    }

    @Override
    public String getDSSConnectionForHive() {
        throw new IllegalArgumentException("unreachable");
    }

    @Override
    public SQLUtils.SQLTable getResolvedHiveTableRef(boolean databaseIsMandatory) {
        String database = null;
        database = !StringUtils.isBlank((String)((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).metastoreDatabaseName) ? ((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).metastoreDatabaseName : this.getConnection().params.defaultMetastoreDatabase;
        if (databaseIsMandatory && StringUtils.isBlank((String)database)) {
            throw ErrorContext.iae((String)("Could not determine metastore database for dataset " + this.dataset.getFullName() + ", please check config"));
        }
        String table = null;
        table = !StringUtils.isBlank((String)((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).metastoreTableName) ? ((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).metastoreTableName : this.dataset.getName();
        String schema = database == null ? null : database.toLowerCase(Locale.ENGLISH);
        String table1 = table == null ? null : table.toLowerCase(Locale.ENGLISH);
        return new SQLUtils.SQLTable(null, schema, table1, true);
    }

    @Override
    public SQLUtils.SQLTable getUnresolvedHiveTableRef() {
        String database = null;
        BuiltinFSDatasets.S3DatasetConfig rawConfig = (BuiltinFSDatasets.S3DatasetConfig)this.config;
        database = !StringUtils.isBlank((String)rawConfig.metastoreDatabaseName) ? rawConfig.metastoreDatabaseName : this.getConnection().params.defaultMetastoreDatabase;
        String table = null;
        table = !StringUtils.isBlank((String)rawConfig.metastoreTableName) ? rawConfig.metastoreTableName : this.dataset.getName();
        return new SQLUtils.SQLTable(null, database, table, true);
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(String path) throws IOException, DKUSecurityException, CodedException {
        String providerPath = path == null ? ((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).path : path;
        FSProvider provider = FSProviderFactory.getProvider("S3", this.authCtx, this.dataset.getProjectKey(), this.resolvedConfig, providerPath, this.getConnection());
        return new AbstractFSDatasetHandler.FSProviderAndPath(provider, providerPath);
    }

    @Override
    public EC2Connection getConnection() {
        try {
            EC2Connection connection = ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, ((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).connection, EC2Connection.class);
            return connection;
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException("Failed to get connection", e);
        }
    }

    @Override
    public DSSConnection getHDFSAbleConnection() {
        return this.getConnection();
    }

    @Override
    public String getInformationalRootPath() throws IOException, DKUSecurityException, CodedException {
        String providerRoot = "s3://" + this.getBucket() + PathUtils.makeLeadingNoTrailing((String)this.getTypedProvider().getRootWithinBucket());
        if (this.isSingleFile()) {
            String singleFile = this.getSingleFile();
            providerRoot = providerRoot.endsWith("/") ? providerRoot.substring(0, providerRoot.length() - 1) : providerRoot;
            singleFile = singleFile.startsWith("/") ? singleFile.substring(1) : singleFile;
            return providerRoot + "/" + singleFile;
        }
        return providerRoot;
    }

    public String getRootPathForSnowflakeFastPath() throws CodedException, IOException, DKUSecurityException {
        String rootPath = this.getInformationalRootPath();
        EC2Connection connection = this.getConnection();
        EC2Connection.Params params = connection.params;
        if (StringUtils.isNotBlank((String)params.snowflakeExternalStageName) && StringUtils.isNotBlank((String)params.snowflakeExternalStagePath)) {
            String pathToReplace = PathUtils.makeNotLeadingNoTrailing((String)params.snowflakeExternalStagePath);
            if (!pathToReplace.startsWith("s3://")) {
                pathToReplace = String.format("s3://%s", pathToReplace);
            }
            rootPath = FastpathUtils.placeSnowflakeStageInRootPath(rootPath, pathToReplace, params.snowflakeExternalStageName, connection.name);
        }
        return rootPath;
    }

    public String getBucketLocation() throws IOException, DKUSecurityException, CodedException {
        return ((S3FSProvider)this.getProvider()).getBucketLocation();
    }

    public String getRootWithinBucket() throws IOException, DKUSecurityException, CodedException {
        return PathUtils.makeLeadingNoTrailing((String)this.getTypedProvider().getRootWithinBucket());
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.S3_META;
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new S3DatasetTestHandler(this.authCtx, this, (DatasetHandler)this, this.dataset);
    }

    @Override
    public String getFullyQualifiedRootPath() throws IOException, DKUSecurityException, CodedException {
        switch (this.hdfsInterface) {
            case S3A: 
            case S3A_DATABRICKS: {
                String providerRoot = "s3a://" + this.getBucket() + PathUtils.makeLeadingNoTrailing((String)this.getTypedProvider().getRootWithinBucket());
                if (this.isSingleFile()) {
                    return providerRoot + "/" + this.getSingleFile();
                }
                return providerRoot;
            }
            case EMRFS: {
                String providerRoot = "s3://" + this.getBucket() + PathUtils.makeLeadingNoTrailing((String)this.getTypedProvider().getRootWithinBucket());
                if (this.isSingleFile()) {
                    return providerRoot + "/" + this.getSingleFile();
                }
                return providerRoot;
            }
            case NONE: {
                return null;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    protected List<AbstractSQLConnection.CustomDatabaseProperty> getHDFSExtraConf() throws IOException, DKUSecurityException {
        ArrayList ret = Lists.newArrayList();
        String bucket = this.getBucket();
        EC2Connection conn = this.getConnection();
        ret.addAll(conn.getHadoopConfigForS3Access(this.authCtx, bucket));
        switch (this.hdfsInterface) {
            case S3A: 
            case S3A_DATABRICKS: {
                ProxySettings proxySettings;
                String s3aPropertyPrefix = conn.getS3APropertyPrefix(bucket);
                Object endpoint = null;
                try {
                    String location = this.getBucketLocation();
                    endpoint = location == null ? conn.getEndpoint() : ("US".equals(location) ? null : RegionUtils.getRegion((String)location).getServiceEndpoint("s3"));
                }
                catch (Exception e) {
                    logger.warn((Object)"could not determine S3 service endpoint", (Throwable)e);
                }
                if (endpoint != null) {
                    logger.info((Object)("using S3 endpoint " + (String)endpoint));
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "endpoint", (String)endpoint, false));
                }
                if (!ApplicationConfigurator.isInSparkDriver() && (proxySettings = conn.getProxySettings()).hasProxy()) {
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "proxy.host", proxySettings.host, false));
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "proxy.port", String.valueOf(proxySettings.port), false));
                    if (proxySettings.hasAuthentication()) {
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "proxy.username", proxySettings.username, false));
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "proxy.password", proxySettings.password, true));
                    }
                }
                if (conn.params.encryptionMode == EncryptionMode.SSE_S3) {
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "server-side-encryption-algorithm", EncryptionMode.SSE_S3.sseAlgorithm.toString(), false));
                }
                if (conn.params.encryptionMode != EncryptionMode.SSE_KMS || !HadoopFlavorUtils.isAtLeast(2, 9)) break;
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "server-side-encryption-algorithm", "SSE-KMS", false));
                if (!StringUtils.isNotBlank((String)conn.params.encryptionKeyId)) break;
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "server-side-encryption.key", conn.params.encryptionKeyId, false));
                break;
            }
            case EMRFS: {
                Object endpoint = null;
                try {
                    String location = this.getBucketLocation();
                    endpoint = location == null ? conn.getEndpoint() : ("US".equals(location) ? null : RegionUtils.getRegion((String)location).getServiceEndpoint("s3"));
                }
                catch (Exception e) {
                    logger.warn((Object)"could not determine S3 service endpoint", (Throwable)e);
                }
                if (endpoint == null) break;
                logger.info((Object)("using S3 endpoint " + (String)endpoint));
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.s3n.endpoint", (String)endpoint, false));
                break;
            }
            case NONE: {
                assert (false);
                break;
            }
        }
        return ret;
    }

    protected FSPath filePath(String relPath, S3ObjectSummary summary) {
        return summary.getLastModified() == null ? new FSPath(relPath, summary.getSize()) : new FSPath(relPath, summary.getSize(), summary.getLastModified().getTime());
    }

    public String getBucket() {
        if (StringUtils.isNotBlank((String)this.getConnection().params.chbucket)) {
            return this.getConnection().params.chbucket;
        }
        return ((BuiltinFSDatasets.S3DatasetConfig)this.resolvedConfig).bucket;
    }

    public static enum HDFSInterface {
        S3A,
        EMRFS,
        S3A_DATABRICKS,
        NONE;

    }

    public static enum EncryptionMode {
        NONE(null, true),
        SSE_S3(ServerSideEncryption.AES256, true),
        SSE_KMS(ServerSideEncryption.AWS_KMS, false);

        public final ServerSideEncryption sseAlgorithm;
        public final boolean sparkDirectWrite;

        private EncryptionMode(ServerSideEncryption sseAlgorithm, boolean sparkDirectWrite) {
            this.sseAlgorithm = sseAlgorithm;
            this.sparkDirectWrite = sparkDirectWrite;
        }
    }
}

