/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.awscore.exception.AwsServiceException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.S3Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.model.Bucket;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class S3FSTestProvider
implements FSTestProvider {
    private final EC2Connection connection;
    private final BuiltinFSDatasets.S3DatasetConfig config;
    private final AuthCtx authCtx;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fstestproviders.s3");

    public S3FSTestProvider(AuthCtx authCtx, DSSConnection connection, AbstractFSDatasetHandler.AbstractFSConfig config) {
        this.authCtx = authCtx;
        this.config = (BuiltinFSDatasets.S3DatasetConfig)config;
        this.connection = (EC2Connection)connection;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Map<String, String> test(boolean listBuckets) throws IOException, CodedException, DKUSecurityException {
        HashMap connectionMetadata = Maps.newHashMap();
        S3Client s3Client = this.connection.getS3Client(this.authCtx);
        String chbucket = this.connection.params.chbucket;
        if (StringUtils.isBlank((String)chbucket) && listBuckets) {
            logger.info((Object)"Listing buckets");
            try {
                List buckets = s3Client.listBuckets().buckets();
                ArrayList<String> bucketsList = new ArrayList<String>(buckets.size());
                for (Bucket bucket : buckets) {
                    bucketsList.add(bucket.name());
                }
                connectionMetadata.put("couldListBuckets", "true");
                connectionMetadata.put("buckets", StringUtils.join(bucketsList, (String)","));
                logger.info((Object)("Listed " + buckets.size() + " buckets"));
            }
            catch (Exception e) {
                connectionMetadata.put("couldListBuckets", "false");
                connectionMetadata.put("bucketsListError", e.getMessage());
                logger.info((Object)("Can't list buckets: " + e.getMessage()), (Throwable)e);
            }
        }
        String bucketName = StringUtils.isNotBlank((String)chbucket) ? chbucket : this.config.bucket;
        connectionMetadata.put("constrainedBucket", this.connection.params.chbucket);
        if (StringUtils.isBlank((String)bucketName)) {
            logger.info((Object)"No bucket specified, only checking connection");
            ConnectionsTestService.checkS3BucketExists(s3Client, "__dku_test_bucket");
        } else {
            boolean bucketExists = false;
            try {
                bucketExists = ConnectionsTestService.checkS3BucketExists(s3Client, bucketName);
            }
            catch (AwsServiceException e) {
                logger.info((Object)("Error checking whether bucket exists: " + bucketName), (Throwable)e);
            }
            connectionMetadata.put("bucketExists", Boolean.toString(bucketExists));
        }
        connectionMetadata.put("connectionValid", "true");
        return connectionMetadata;
    }
}

