/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.hdfs;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import java.io.IOException;
import java.util.List;

public class HDFSLocatableHandler {
    private final AnyLoc loc;
    private final ITaggingService.TaggableType objectType;
    private final HDFSProvider hdfsProvider;
    private final boolean isSingleFile;
    private final String configuredDatasetRootPathWithinAuthority;
    private final PartitioningScheme partitioningScheme;

    public HDFSLocatableHandler(HDFSDatasetHandler handler) throws IOException, DKUSecurityException, CodedException {
        this.loc = handler.getDataset().getLoc();
        this.objectType = ITaggingService.TaggableType.DATASET;
        this.hdfsProvider = handler.getTypedProvider();
        this.isSingleFile = handler.isSingleFile();
        this.configuredDatasetRootPathWithinAuthority = handler.getConfiguredDatasetRootPathWithinAuthority();
        this.partitioningScheme = handler.getDataset().getPartitioningSchema();
    }

    public HDFSLocatableHandler(ManagedFolderHandler handler) throws IOException, DKUSecurityException, CodedException {
        this.loc = new DatasetLocUtils.DatasetLoc(handler.getFolder().getProjectKey(), handler.getFolder().getId());
        this.objectType = ITaggingService.TaggableType.MANAGED_FOLDER;
        this.hdfsProvider = (HDFSProvider)handler.getProvider();
        this.isSingleFile = false;
        this.configuredDatasetRootPathWithinAuthority = this.hdfsProvider.getRoot();
        this.partitioningScheme = handler.getFolder().getPartitioningSchema();
    }

    public ITaggingService.TaggableType getObjectType() {
        return this.objectType;
    }

    public AnyLoc getLoc() {
        return this.loc;
    }

    public String getConnectionRootWithinURIAuthority() {
        return this.hdfsProvider.getConnectionRootWithinURIAuthority();
    }

    public HDFSProvider getHDFSProvider() {
        return this.hdfsProvider;
    }

    public String getConfiguredRootPathWithinAuthority() {
        return this.configuredDatasetRootPathWithinAuthority;
    }

    public String getEffectiveRootWithinAuthority() {
        return this.hdfsProvider.getRoot();
    }

    public boolean isSingleFile() {
        return this.isSingleFile;
    }

    public String getRootPathUri() {
        return this.hdfsProvider.getRootPathUri();
    }

    public List<SimpleKeyValue> getFSExtraConf() {
        return this.hdfsProvider.getFSExtraConf();
    }

    public String getPartitionRelPath(Partition targetPartition) {
        return FilePartitioner.getRelPath(targetPartition, this.partitioningScheme);
    }
}

