/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.coremodel.InfoMessage;

public enum SQLCodes implements InfoMessage.MessageCode
{
    ERR_SQL_CANNOT_LOAD_DRIVER("Failed to load database driver", InfoMessage.FixabilityCategory.ADMIN_INSTALLATION),
    ERR_SQL_DB_UNREACHABLE("Failed to reach database", InfoMessage.FixabilityCategory.THIRD_PARTY_SYSTEM_CONNECTION),
    ERR_SQL_TABLE_NOT_FOUND("SQL Table not found", InfoMessage.FixabilityCategory.USER_CONFIG_OR_BUILD),
    ERR_SQL_ORACLE_KERBEROS_SETUP_MAY_BE_INCOMPLETE("May need additional Kerberos-related properties", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_CONNECTIONS),
    ERR_SQL_IMPALA_MEMORYLIMIT("Impala memory limit exceeded", InfoMessage.FixabilityCategory.THIRD_PARTY_SYSTEM),
    ERR_SQL_VERTICA_TOOMANYROS("Error in Vertica: too many ROS", InfoMessage.FixabilityCategory.THIRD_PARTY_SYSTEM),
    ERR_SQL_VERTICA_TOOMANYSESSIONS("Error in Vertica: too many sessions open concurrently", InfoMessage.FixabilityCategory.USER_CONFIG_OR_ADMIN),
    ERR_SQL_POSTGRESQL_TOOMANYSESSIONS("Error in PostgreSQL: too many sessions open concurrently", InfoMessage.FixabilityCategory.USER_CONFIG_OR_ADMIN),
    ERR_BIGQUERY_INVALID_SCHEMA_NAME("Invalid BigQuery schema name", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_BIGQUERY_INCOMPATIBLE_SCHEMA("BigQuery table already exists but with an incompatible schema", InfoMessage.FixabilityCategory.THIRD_PARTY_SYSTEM_CONNECTION),
    ERR_BIGQUERY_EMPTY_SCHEMA("Invalid schema for BigQuery table: no column defined.", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_NOT_SYNAPSE("The connection has been declared as an Azure Synapse connection but it does not seems to be the case.", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_CONNECTIONS),
    ERR_SYNAPSE_CSV_DELIMITER("Bad delimiter setup", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET),
    ERR_SYNAPSE_CSV_ABFS_NO_HIERARCHICAL_NAMESPACE("Bad ABFS setup", InfoMessage.FixabilityCategory.USER_CONFIG_OR_ADMIN),
    ERR_SQL_INVALID_CONF("Invalid connection configuration", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_CONNECTIONS),
    ERR_SQL_CANNOT_SYNC_TABLE_DESC("Failed to synchronize table description", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_SQL_CANNOT_SYNC_COLUMN_DESC("Failed to synchronize column description", InfoMessage.FixabilityCategory.IRRELEVANT),
    WARN_SQL_DESC_TRUNCATED("Description has been truncated", InfoMessage.FixabilityCategory.IRRELEVANT);

    private final String title;
    private final InfoMessage.FixabilityCategory fixability;

    private SQLCodes(String title, InfoMessage.FixabilityCategory fixability) {
        this.title = title;
        this.fixability = fixability;
    }

    public String getCode() {
        return this.name();
    }

    public String getCodeTitle() {
        return this.title;
    }

    public InfoMessage.FixabilityCategory getFixability() {
        return this.fixability;
    }
}

