/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.sampling;

import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.eda.EdaErrorCodes;
import com.dataiku.dip.eda.compute.sampling.DataSpec;
import com.dataiku.dip.eda.compute.sampling.Sample;
import com.dataiku.dip.eda.compute.sampling.SampleManager;
import com.dataiku.dip.eda.compute.sampling.SampleMappingService;
import com.dataiku.dip.eda.compute.sampling.SampleRequest;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SamplesService {
    @Autowired
    DatasetAccessService datasetAccessService;
    @Autowired
    FutureService futureService;
    @Autowired
    SampleManager sampleManager;
    @Autowired
    SampleMappingService sampleMappingService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    PermissionsService permissionsService;
    @Autowired
    ProjectsService projectsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.eda.samples");

    public Sample getCurrentSample_NT(DSSAuthCtx authCtx, TaggableObjectsService.TaggableObjectRef key, DataSpec dataSpec) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        TransactionContext.assertNoAttachedTransaction();
        SampleRequest sampleRequest = this.buildSampleRequest_NT(authCtx, key.projectKey, dataSpec);
        Sample associatedSample = this.sampleMappingService.getAssociatedSample(key);
        logger.traceV("Sample %s found with sample request %s", new Object[]{null != associatedSample ? associatedSample.id : "null", JSON.pretty((Object)sampleRequest)});
        if (associatedSample == null || !associatedSample.canFulfillRequest(sampleRequest)) {
            if (null != associatedSample) {
                logger.infoV("Sample %s can not fulfill request", new Object[]{associatedSample.id});
            }
            return null;
        }
        if (dataSpec.autoRefreshSample && this.sampleManager.isProvablyOutdated_NT(authCtx, associatedSample)) {
            logger.infoV("Sample %s is outdated", new Object[]{associatedSample.id});
            return null;
        }
        return associatedSample;
    }

    public Sample getOrRebuildCurrentSample_NT(DSSAuthCtx authCtx, TaggableObjectsService.TaggableObjectRef key, DataSpec dataSpec) throws Exception {
        Sample sample = this.getCurrentSample_NT(authCtx, key, dataSpec);
        if (sample == null) {
            sample = this.buildSample_NT(authCtx, key, dataSpec);
        }
        return sample;
    }

    public Sample getSampleIfAccessibleByUser(AuthCtx authCtx, String sampleId) throws CodedException, IOException, DKUSecurityException {
        Sample sample = this.sampleManager.findSample(sampleId);
        if (sample == null) {
            throw new CodedException((InfoMessage.MessageCode)EdaErrorCodes.ERR_EDA_COMPUTE_NO_SUCH_SAMPLE, "Sample not found: " + sampleId);
        }
        this.permissionsService.checkProjectPrivileges(authCtx, sample.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        this.projectsService.failIfNoDatasetReadUseAccess(authCtx, sample.getDatasetLoc(), sample.getProjectKey());
        return sample;
    }

    public FutureResponse<Sample> buildSampleInFuture(final DSSAuthCtx authCtx, final TaggableObjectsService.TaggableObjectRef key, final DataSpec dataSpec) throws Exception {
        return this.futureService.runFuture(new SimpleFutureThread<Sample>((AuthCtx)authCtx){

            public FuturePayload getPayload() {
                String displayName = "Build sample for " + String.valueOf(key) + " for dataset " + dataSpec.inputDatasetSmartName + " with dataset selection " + dataSpec.datasetSelection.toString();
                FuturePayload fp = FuturePayload.newSimple((String)"eda_build_sample", (String)"Build EDA sample");
                fp.targets.add(new FuturePayload.FuturePayloadTarget(key.projectKey, key.id, displayName, null));
                return fp;
            }

            @Override
            protected Sample compute() throws Exception {
                return SamplesService.this.buildSample_NT(authCtx, key, dataSpec);
            }
        }, 0L, new TypeToken<FutureResponse<Sample>>(){});
    }

    public Sample buildSample_NT(DSSAuthCtx authCtx, TaggableObjectsService.TaggableObjectRef key, DataSpec dataSpec) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        SampleRequest sampleRequest = this.buildSampleRequest_NT(authCtx, key.projectKey, dataSpec);
        Sample newSample = this.sampleManager.createSample_NT(sampleRequest);
        this.sampleMappingService.setAssociatedSample(key, newSample);
        return newSample;
    }

    public SampleRequest buildSampleRequest_NT(DSSAuthCtx authCtx, String projectKey, DataSpec dataSpec) throws IOException, DKUSecurityException {
        String containerConfName = new ContainerExecConfigSelector().selectConfName_autoTXN(authCtx, projectKey, dataSpec.containerSelection);
        Dataset dataset = this.getDataset(DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, dataSpec.inputDatasetSmartName));
        return new SampleRequest(authCtx, projectKey, dataset, dataSpec, containerConfName);
    }

    public void removeByRef(TaggableObjectsService.TaggableObjectRef key) throws IOException {
        this.sampleMappingService.removeSample(key);
    }

    private Dataset getDataset(AnyLoc datasetLoc) throws IOException {
        logger.infoV("Loading dataset from loc %s", new Object[]{datasetLoc.getFullName()});
        try (Transaction t = this.transactionService.beginRead();){
            Dataset dataset = this.datasetAccessService.getMandatory(datasetLoc);
            return dataset;
        }
    }
}

