/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.fragments;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.Count;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.CrossGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.common.GroupingHelpers;
import com.dataiku.dip.eda.worksheets.models.BinningMode;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public class NumericalHistogramFragment
extends ImmutableValueObject {
    public List<Filter> bins;
    public long[] counts;
    @Nullable
    public long[] highlightedCounts;

    public static NumericalHistogramFragment buildResult(ComputationResult result) {
        boolean hasHighlighting;
        NumericalHistogramFragment histogram = new NumericalHistogramFragment();
        GroupedComputation.GroupedComputationResult groupedResults = result.asGrouped();
        CrossGrouping.CrossGroupingResult crossGroupingResult = groupedResults.groups.asCross();
        UnionGrouping.UnionGroupingResult subsetsGroupingResult = crossGroupingResult.groups.get(0).asUnion();
        GroupingResult binningResults = crossGroupingResult.groups.get(1);
        boolean bl = hasHighlighting = subsetsGroupingResult.size() > 1;
        if (hasHighlighting) {
            histogram.highlightedCounts = new long[binningResults.size()];
        }
        histogram.counts = new long[binningResults.size()];
        for (int i = 0; i < binningResults.size(); ++i) {
            histogram.counts[i] = groupedResults.results.get((int)i).as(Count.CountResult.class).count;
            if (!hasHighlighting) continue;
            histogram.highlightedCounts[i] = groupedResults.results.get((int)(i + binningResults.size())).as(Count.CountResult.class).count;
        }
        histogram.bins = binningResults.listFilters();
        return histogram;
    }

    public static Computation getPlan(Variable variable) {
        return NumericalHistogramFragment.getPlan(variable, BinningMode.AUTO, null, null, null);
    }

    public static Computation getPlan(Variable variable, BinningMode binningMode, Integer nbBins, double[] customBinningBoundaries, @Nullable Filter highlightFilter) {
        Grouping grouping = GroupingHelpers.handleCustomizableVariableGrouping(variable, binningMode, nbBins, false, customBinningBoundaries, false);
        ArrayList<Grouping> subsets = new ArrayList<Grouping>();
        subsets.add(SubsetGrouping.all());
        if (highlightFilter != null) {
            subsets.add(new SubsetGrouping(highlightFilter));
        }
        return new GroupedComputation(new Count(), new CrossGrouping(new UnionGrouping(subsets), grouping));
    }
}

