/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.TimeSeriesCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.suggester.ComputationSampler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class CardComputer {
    private final ComputationRunner fullSampleRunner;

    public CardComputer(ComputationRunner fullSampleRunner) {
        this.fullSampleRunner = fullSampleRunner;
    }

    public <T> void computeCards(List<T> items, Function<T, Card> cardGetter, BiConsumer<T, Card> cardSetter, BiConsumer<T, CardResult> cardResultSetter) throws Exception {
        ArrayList<CompiledCard> compiledCards = new ArrayList<CompiledCard>();
        ComputationSampler sampler = new ComputationSampler();
        for (T item : items) {
            Card card = cardGetter.apply(item).fixup();
            cardSetter.accept(item, card);
            CompiledCard compiledCard = card.compile();
            compiledCards.add(compiledCard);
            if (card instanceof TimeSeriesCard) {
                TimeSeriesCard timeSeriesCard = (TimeSeriesCard)card;
                sampler.withTopNTimeSampling(compiledCard.getComputationPlan(), timeSeriesCard.timeColumn.name);
                continue;
            }
            sampler.withRandomSampling(compiledCard.getComputationPlan());
        }
        try (ComputationResultSession session = sampler.computeSession(this.fullSampleRunner);){
            ComputationResultDataStreamer dataStreamer = session.getDataStreamer();
            MultiComputation.MultiComputationResult mcr = session.getComputationResult().asMulti();
            for (int i = 0; i < items.size(); ++i) {
                T item = items.get(i);
                CompiledCard compiledCard = (CompiledCard)compiledCards.get(i);
                ComputationResult computationResult = mcr.get(i);
                CardResult cardResult = compiledCard.buildResult(computationResult, dataStreamer);
                cardResultSetter.accept(item, cardResult);
            }
        }
    }
}

