/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.worksheets.cards.CorrelationMatrixCard;
import com.dataiku.dip.eda.worksheets.cards.PCACard;
import com.dataiku.dip.eda.worksheets.cards.ScatterPlot3DCard;
import com.dataiku.dip.eda.worksheets.cards.common.HeatmapParams;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MultivariateSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.size() < 2) {
            return Collections.emptyList();
        }
        if (!sniffedVariables.stream().allMatch(SniffedVariable::holdsNumericalValues)) {
            return Collections.emptyList();
        }
        List<Variable> variables = sniffedVariables.stream().map(Suggester::toContinuousVariable).collect(Collectors.toList());
        ArrayList<SuggestCards.SuggestedCard> suggestions = new ArrayList<SuggestCards.SuggestedCard>();
        suggestions.add(this.suggestCorrelationMatrix(variables));
        suggestions.add(this.suggestPCA(variables));
        if (variables.size() == 3) {
            suggestions.add(this.suggestScatter3D(variables));
        }
        return suggestions;
    }

    private SuggestCards.SuggestedCard suggestScatter3D(List<Variable> variables) {
        ScatterPlot3DCard card = new ScatterPlot3DCard(variables.get(0), variables.get(1), variables.get(2));
        return new SuggestCards.SuggestedCard("Scatter 3D plot", card);
    }

    private SuggestCards.SuggestedCard suggestPCA(List<Variable> variables) {
        PCACard card = new PCACard(variables, new HeatmapParams());
        card.showComponents = false;
        card.showScatterPlot = true;
        card.showLoadingPlot = true;
        card.showScreePlot = true;
        return new SuggestCards.SuggestedCard("PCA", card);
    }

    private SuggestCards.SuggestedCard suggestCorrelationMatrix(List<Variable> variables) {
        CorrelationMatrixCard card = new CorrelationMatrixCard(variables, CorrelationMatrixCard.CorrelationMetric.SPEARMAN, new HeatmapParams());
        return new SuggestCards.SuggestedCard("Correlation matrix", card);
    }
}

