/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eventserver;

import com.dataiku.dip.eventserver.Event;
import com.dataiku.dip.eventserver.ProcessingQueue;
import com.dataiku.dip.eventserver.Utils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.springframework.beans.factory.annotation.Autowired;

public class EventServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ProcessingQueue processingQueue;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.eventserver.api");

    public EventServlet() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    private void send400(HttpServletRequest req, HttpServletResponse resp, String message) {
        try {
            logger.warn((Object)("Rejected API message from " + req.getRemoteAddr() + ": " + message));
            resp.setStatus(400);
            resp.getWriter().write("Bad request: " + message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String usedAuthKey = null;
        try {
            usedAuthKey = this.processingQueue.getSettings().checkEventCallAuth(req);
        }
        catch (DKUSecurityException e) {
            logger.error((Object)"Authentication failed", (Throwable)e);
            resp.setStatus(401);
            return;
        }
        String data = null;
        if ("application/gzip".equals(req.getContentType())) {
            try {
                data = IOUtils.toString((InputStream)new GZIPInputStream((InputStream)req.getInputStream()), (String)"utf8");
            }
            catch (Exception e) {
                this.send400(req, resp, "Malformed gzipped message, " + e.getMessage());
                return;
            }
        } else if ("application/json".equals(req.getContentType())) {
            try {
                data = IOUtils.toString((InputStream)req.getInputStream(), (String)"utf8");
            }
            catch (Exception e) {
                this.send400(req, resp, "Malformed JSON message, " + e.getMessage());
                return;
            }
        } else {
            this.send400(req, resp, "Unexpected content type");
            return;
        }
        Message m = new Message();
        try {
            m = (Message)new Gson().fromJson(data, Message.class);
        }
        catch (Exception e) {
            this.send400(req, resp, "Malformed JSON message, " + e.getMessage());
            return;
        }
        if (m.topic == null) {
            this.send400(req, resp, "Malformed JSON message, no topic");
            return;
        }
        if (m.events == null) {
            this.send400(req, resp, "Malformed JSON message, no events");
            return;
        }
        for (JsonObject clientEvent : m.events) {
            Event event = new Event();
            event.usedAuthKey = usedAuthKey;
            event.origAddress = Utils.computeRealRemoteAddress(req);
            event.clientEvent = clientEvent;
            event.routingKey = m.routingKey;
            event.topic = m.topic;
            logger.trace(() -> "Pushing trace: " + JSON.json((Object)event));
            this.processingQueue.push(event);
        }
    }

    static class Message {
        String topic;
        String routingKey;
        List<JsonObject> events;

        Message() {
        }
    }
}

