/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eventserver.targets;

import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.eventserver.Event;
import com.dataiku.dip.processors.ConnectionPathTargetProcessor;
import com.dataiku.dip.processors.ConnectionPathTargetProcessorSettings;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class ConnectionPathEventTargetProcessor
extends ConnectionPathTargetProcessor<Event> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.event");

    public ConnectionPathEventTargetProcessor(ConnectionPathTargetProcessorSettings settings) {
        super(settings, true);
    }

    @Override
    public synchronized void process(Event req) throws Exception {
        if (this.invalidConfiguration) {
            return;
        }
        this.getLogger().trace((Object)("Processing: " + JSON.json((Object)req)));
        try (CredentialsRemoteFetchConfigurationProvider.FetchAsAuthCtx authCtxForRemote = CredentialsRemoteFetchConfigurationProvider.fetchAs(this.authCtx);){
            JsonObject jo = new JsonObject();
            jo.add("clientEvent", (JsonElement)req.clientEvent);
            jo.addProperty("origAddress", req.origAddress);
            if (req.referer != null) {
                jo.addProperty("referer", req.referer);
            }
            jo.addProperty("serverTimestamp", DKUDateUtils.isoFormatLocal((long)req.serverTS));
            this.process_internal(jo, req.topic, req.routingKey);
        }
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    public String getProcessorName() {
        return "event server target";
    }
}

