/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.output;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.export.ExportCodes;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.export.output.ExportToStream;
import com.dataiku.dip.utils.DKUFileUtils;
import java.io.File;
import java.io.FileOutputStream;

public class ExportToFile
implements ExportOutput {
    private static final int DEFAULT_EXPORT_MAX_SIZE_MB = 20000;
    private ExportToStream writer;
    private final File outputFile;
    private final ExportParams exportParams;
    private Schema schema;
    private ExportService.LocalExportJob job;
    private ColumnFactory cf;
    private ExportOutput.ExportContext exportContext;

    public ExportToFile(ExportStatus status, ExportParams params) {
        this.outputFile = new File(status.targetFile);
        this.exportParams = params;
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, Schema schema, ColumnFactory cf) throws Exception {
        this.schema = schema;
        this.job = job;
        this.cf = cf;
    }

    @Override
    public void setExportContext(ExportOutput.ExportContext exportContext) {
        this.exportContext = exportContext;
    }

    @Override
    public void stream(RowInputStream stream) throws Exception {
        DKUFileUtils.mkdirsParent((File)this.outputFile);
        try {
            long maxFileSizeMB = DKUApp.getParams().getLongParam("dku.exports.file.maxSizeMB", 20000L);
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile, false);
                 ExportToStream writer = new ExportToStream(fileOutputStream, this.exportParams, maxFileSizeMB);){
                this.writer = writer;
                writer.setExportContext(this.exportContext);
                writer.initialize(this.job, this.schema, this.cf);
                writer.stream(stream);
                fileOutputStream.flush();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            DKUFileUtils.forceDelete((File)this.outputFile);
            throw e;
        }
        catch (CodedRuntimeException e) {
            if (e.getCode() == ExportCodes.ERR_EXPORT_OUTPUT_TOO_LARGE) {
                DKUFileUtils.forceDelete((File)this.outputFile);
            }
            throw e;
        }
    }

    @Override
    public long getWrittenBytes() throws Exception {
        ExportToStream localWriter = this.writer;
        if (localWriter != null) {
            return localWriter.getWrittenBytes();
        }
        return -1L;
    }

    @Override
    public void close() {
    }

    @Override
    public void checkFeasability(ExportService.LocalExportJob job) {
    }
}

