/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalml.mlflow;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.externalml.mlflow.DatabricksUtilsKernelProtocol;
import com.dataiku.dip.externalml.mlflow.DatabricksUtilsRunner;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.util.DKUExecutors;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.GuavaCacheMetrics;
import com.dataiku.dip.utils.Params;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatabricksUtilsKernelCachingService {
    public static final String CACHE_NAME = "mlflowutils.kernels";
    private static final int KERNEL_CACHE_DEFAULT_EXPIRATION_TIME_IN_MINUTES = 5;
    public static final String KERNEL_CACHE_EXPIRATION_MINUTES_CONFIG_KEY = "dku.caches.mlflowutils.kernels.expirationMn";
    @Autowired
    public CodeEnvResolutionService codeEnvResolutionService;
    private final Cache<String, DatabricksUtilsRunner> databricksUtilsRunnerCache;
    private DKULogger logger = DKULogger.getLogger((String)"dku.services.mlflowutilskernel.cache");

    public DatabricksUtilsKernelCachingService() {
        Params p = ApplicationConfigurator.getParams();
        long kernelCacheExpirationTimeMn = p.getLongParam(KERNEL_CACHE_EXPIRATION_MINUTES_CONFIG_KEY, 5L);
        this.logger.infoV("Init mlflowutils.kernels kernel cache with expirationMn %d", new Object[]{kernelCacheExpirationTimeMn});
        this.databricksUtilsRunnerCache = CacheBuilder.newBuilder().expireAfterAccess(kernelCacheExpirationTimeMn, TimeUnit.MINUTES).removalListener(removalNotification -> {
            try {
                ((DatabricksUtilsRunner)removalNotification.getValue()).close();
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to remove kernel", (Throwable)e);
            }
        }).build();
        DSSMetrics.registry().registerAll(GuavaCacheMetrics.cacheMetricsSet((String)CACHE_NAME, this.databricksUtilsRunnerCache));
    }

    @PostConstruct
    public void postConstruct() {
        int CLEANUP_PERIOD_MN = 2;
        this.logger.infoV("Scheduling periodic cleanup of MLFlow utils kernel cache every %d minutes, starting in %d minutes", new Object[]{2, 2});
        DKUExecutors.newNamedSingleDaemonThreadExecutor("MLFlowKernels-cleanup").scheduleWithFixedDelay(this::cleanUp, 2L, 2L, TimeUnit.MINUTES);
    }

    @Nullable
    public DatabricksUtilsRunner getIfPresent(Object o) {
        return (DatabricksUtilsRunner)this.databricksUtilsRunnerCache.getIfPresent(o);
    }

    public void put(String s, DatabricksUtilsRunner databricksUtilsRunner) {
        this.databricksUtilsRunnerCache.put((Object)s, (Object)databricksUtilsRunner);
    }

    private synchronized DatabricksUtilsRunner createDatabricksUtilsRunner(@Nonnull DSSAuthCtx owner, String codeEnvName, @Nonnull List<File> extraLogFiles) throws Exception {
        SimplePythonKernel kernel = SimplePythonKernelFactory.prepareKernel(owner, "databricksUtils", GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, codeEnvName, "dataiku.external_ml.databricks.utils_server", true, null, "mlflow-utils");
        for (File logFile : extraLogFiles) {
            if (logFile == null) continue;
            kernel.appendKernelLogsToLogFile(logFile);
        }
        DatabricksUtilsKernelProtocol protocol = new DatabricksUtilsKernelProtocol(kernel);
        return new DatabricksUtilsRunner(protocol);
    }

    public synchronized DatabricksUtilsRunner getCachedMLflowUtilsRunner(@Nonnull DSSAuthCtx owner, @Nonnull DatabricksModelDeploymentConnection connection, List<File> extraLogFiles) throws Exception {
        String codeEnvName = DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.DATABRICKS_UTILS_CODE_ENV);
        this.codeEnvResolutionService.checkEnvExists(CodeEnvModel.EnvLang.PYTHON, codeEnvName);
        String kernelId = connection.name + "-" + owner.getIdentifier() + "-" + codeEnvName;
        DatabricksUtilsRunner mlflowUtilsRunner = this.getIfPresent(kernelId);
        if (mlflowUtilsRunner != null && !mlflowUtilsRunner.isDeadKernel() && CollectionUtils.isEmpty(extraLogFiles)) {
            this.logger.info((Object)("A MLflow utils kernel is already up for " + kernelId + " : using it for computation"));
        } else if (CollectionUtils.isEmpty(extraLogFiles)) {
            this.logger.info((Object)("No existing MLflow utils kernel was found for id " + kernelId + " , starting one"));
            mlflowUtilsRunner = this.createDatabricksUtilsRunner(owner, codeEnvName, List.of());
            this.put(kernelId, mlflowUtilsRunner);
        } else {
            this.logger.info((Object)"No caching due to log files used in the MLflow utils kernel, starting one");
            mlflowUtilsRunner = this.createDatabricksUtilsRunner(owner, codeEnvName, extraLogFiles);
        }
        mlflowUtilsRunner.incRefCount();
        return mlflowUtilsRunner;
    }

    public void cleanUp() {
        if (this.databricksUtilsRunnerCache.size() > 0L) {
            this.logger.info((Object)"Cleaning up MLflow utils kernel cache");
        }
        this.databricksUtilsRunnerCache.cleanUp();
    }

    public void invalidateAll() {
        this.logger.info((Object)"Invalidating MLflow utils kernel cache");
        this.databricksUtilsRunnerCache.invalidateAll();
    }
}

