/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.custom;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.CustomJavaRuntimeDataProvider;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.formats.custom.CustomJavaFormatDesc;
import com.dataiku.dip.formats.custom.LoadedJavaFormat;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.plugin.CustomFormat;
import com.dataiku.dip.plugin.CustomFormatOutput;
import com.dataiku.dip.plugin.tools.PluginClazzLoader;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CustomJavaOutputFormatter
implements OutputFormatter {
    private final JsonObject config;
    private final LoadedJavaFormat loaded;
    private final CustomJavaRuntimeDataProvider service;
    private final AuthCtx authCtx;
    private final String projectKey;
    private Schema schema;
    private WarningsContext warningsContext;
    private CustomFormatOutput writer;
    private List<Column> headerColumns;
    private static Logger logger = Logger.getLogger((String)"dku.formats.custom.output");

    public CustomJavaOutputFormatter(AuthCtx authCtx, String projectKey, JsonObject config, LoadedJavaFormat loaded, CustomJavaRuntimeDataProvider service) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.config = config;
        this.loaded = loaded;
        this.service = service;
    }

    public String getExtension() {
        if (((CustomJavaFormatDesc)this.loaded.getDesc()).mime != null && StringUtils.isNotBlank((String)((CustomJavaFormatDesc)this.loaded.getDesc()).mime.extension)) {
            return ((CustomJavaFormatDesc)this.loaded.getDesc()).mime.extension;
        }
        return ".bin";
    }

    public void header(ColumnFactory cf, OutputStream os) throws Exception {
        ClassLoader classLoader = this.service.getClassloader(this.loaded.getType());
        CustomFormat format = (CustomFormat)new PluginClazzLoader(classLoader).loadClazz(((CustomJavaFormatDesc)this.loaded.getDesc()).formatClass);
        PluginSettingsResolver.ResolvedSettings resolvedSettings = this.service.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
        this.writer = format.getWriter(resolvedSettings.config, resolvedSettings.pluginConfig);
        this.writer.setOutputSchema(this.schema);
        this.writer.setWarningsContext(this.warningsContext);
        logger.info((Object)"Created custom format output");
        this.writer.header(cf, os);
        this.headerColumns = Lists.newArrayList();
        for (SchemaColumn c2 : this.schema.getColumns()) {
            this.headerColumns.add(cf.column(c2.getName()));
        }
    }

    public void format(Row row, ColumnFactory cf, OutputStream os) throws Exception {
        this.writer.format(row, cf, os);
    }

    public void footer(ColumnFactory cf, OutputStream os) throws Exception {
        if (this.writer != null) {
            this.writer.footer(cf, os);
            this.writer.close();
            this.writer = null;
        }
    }

    public void cancel(OutputStream os) throws Exception {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public void setOutputSchema(Schema schema) {
        this.schema = schema;
    }

    public void setWarningsContext(WarningsContext warningsContext) {
        this.warningsContext = warningsContext;
    }
}

