/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.excel.model.range;

import com.dataiku.dip.formats.excel.model.range.ExcelUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellRangeAddress;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellRangeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExcelRange {
    private int firstRow = Integer.MAX_VALUE;
    private int firstCol = Integer.MAX_VALUE;
    private int lastRow = Integer.MIN_VALUE;
    private int lastCol = Integer.MIN_VALUE;
    private final CellRangeAddress[] ranges;
    private final List<Range> colRanges = new ArrayList<Range>();
    private final List<Range> rowRanges = new ArrayList<Range>();
    private final Set<Integer> includedColumns = new HashSet<Integer>();

    public static ExcelRange from(String range) {
        return new ExcelRange(range);
    }

    public static ExcelRange from(CellRangeAddress range) {
        return new ExcelRange(range.formatAsString());
    }

    public static ExcelRange from(List<CellRangeAddress> ranges) {
        CellRangeAddress[] mergedRanges = CellRangeUtil.mergeCellRanges((CellRangeAddress[])ranges.toArray(new CellRangeAddress[0]));
        return new ExcelRange(mergedRanges);
    }

    public ExcelRange(String range) {
        this.ranges = this.parse(range);
        this.initializeRanges();
        this.computeFirstLastRowColumn();
    }

    private ExcelRange(CellRangeAddress[] ranges) {
        this.ranges = (CellRangeAddress[])ranges.clone();
        this.initializeRanges();
        this.computeFirstLastRowColumn();
    }

    private void initializeRanges() {
        for (CellRangeAddress range : this.ranges) {
            this.colRanges.add(new Range(range.getFirstColumn(), range.getLastColumn()));
            if (range.getFirstColumn() != -1) {
                for (int i = range.getFirstColumn(); i <= range.getLastColumn(); ++i) {
                    this.includedColumns.add(i);
                }
            }
            this.rowRanges.add(new Range(range.getFirstRow(), range.getLastRow()));
        }
        Collections.sort(this.colRanges);
        this.mergeRanges(this.colRanges);
        Collections.sort(this.rowRanges);
        this.mergeRanges(this.rowRanges);
    }

    private void mergeRanges(List<Range> ranges) {
        if (ranges.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < ranges.size() - 1) {
            Range currentRange = ranges.get(i);
            Range nextRange = ranges.get(i + 1);
            if (nextRange.start <= currentRange.end) {
                ranges.set(i, new Range(currentRange.start, nextRange.end));
                ranges.remove(i + 1);
                continue;
            }
            ++i;
        }
    }

    public boolean containsRow(int excelRowIdx) {
        if (!this.hasWholeRowSubrange()) {
            return true;
        }
        for (Range currentRange : this.rowRanges) {
            if (excelRowIdx < currentRange.start) {
                return false;
            }
            if (excelRowIdx > currentRange.end) continue;
            return true;
        }
        return false;
    }

    public boolean containsColumn(int excelColumnIdx) {
        if (!this.hasWholeColumnSubrange()) {
            return true;
        }
        return this.includedColumns.contains(excelColumnIdx);
    }

    public boolean containsCell(int rowIdx, int colIdx) {
        return Arrays.stream(this.ranges).anyMatch(range -> this.rangeContainsCell((CellRangeAddress)range, rowIdx, colIdx));
    }

    private boolean rangeContainsCell(CellRangeAddress range, int rowIdx, int colIdx) {
        boolean isColIdxInRange;
        boolean isWholeRowRange;
        boolean isWholeColumnRange = range.getFirstRow() == -1 && range.getLastRow() == -1;
        boolean bl = isWholeRowRange = range.getFirstColumn() == -1 && range.getLastColumn() == -1;
        if (isWholeRowRange && isWholeColumnRange) {
            return true;
        }
        boolean isRowIdxInRange = range.getFirstRow() <= rowIdx && rowIdx <= range.getLastRow();
        boolean bl2 = isColIdxInRange = range.getFirstColumn() <= colIdx && colIdx <= range.getLastColumn();
        if (isWholeColumnRange) {
            return isColIdxInRange;
        }
        if (isWholeRowRange) {
            return isRowIdxInRange;
        }
        return isRowIdxInRange && isColIdxInRange;
    }

    public int getColumnGapFromStart(int colIndex) {
        if (!this.hasWholeColumnSubrange() || colIndex <= this.firstCol || this.colRanges.isEmpty()) {
            return 0;
        }
        int gap = 0;
        Range prevRange = this.colRanges.get(0);
        for (int i = 1; i < this.colRanges.size(); ++i) {
            Range currentRange = this.colRanges.get(i);
            if (colIndex < currentRange.start) break;
            gap += currentRange.start - prevRange.end - 1;
            prevRange = currentRange;
        }
        if (prevRange.end < colIndex) {
            gap += colIndex - prevRange.end - 1;
        }
        return gap;
    }

    public boolean hasWholeColumnSubrange() {
        return this.firstCol != -1;
    }

    public boolean hasWholeRowSubrange() {
        return this.firstRow != -1;
    }

    private CellRangeAddress[] parse(String s) throws IllegalArgumentException {
        ArrayList<CellRangeAddress> ranges = new ArrayList<CellRangeAddress>();
        for (String range : s.split(",")) {
            ranges.add(ExcelUtils.valueOfRange(range));
        }
        return CellRangeUtil.mergeCellRanges((CellRangeAddress[])ranges.toArray(new CellRangeAddress[0]));
    }

    private void computeFirstLastRowColumn() {
        for (CellRangeAddress range : this.ranges) {
            this.firstRow = Math.min(this.firstRow, range.getFirstRow());
            this.firstCol = Math.min(this.firstCol, range.getFirstColumn());
            this.lastRow = Math.max(this.lastRow, range.getLastRow());
            this.lastCol = Math.max(this.lastCol, range.getLastColumn());
        }
    }

    public int getFirstColumn() {
        return this.firstCol;
    }

    public int getLastColumn() {
        return this.lastCol;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public CellRangeAddress[] getRanges() {
        return this.ranges;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExcelRange range = (ExcelRange)o;
        return this.firstRow == range.firstRow && this.firstCol == range.firstCol && this.lastRow == range.lastRow && this.lastCol == range.lastCol && Objects.deepEquals(this.ranges, range.ranges);
    }

    public int hashCode() {
        return Objects.hash(this.firstRow, this.firstCol, this.lastRow, this.lastCol, Arrays.hashCode(this.ranges));
    }

    private static class Range
    implements Comparable<Range> {
        int start;
        int end;

        private Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.start == range.start && this.end == range.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        @Override
        public int compareTo(@NotNull Range r2) {
            if (this.start == r2.start && this.end == r2.end) {
                return 0;
            }
            if (this.start < r2.start) {
                return -1;
            }
            if (this.start > r2.start) {
                return 1;
            }
            return this.end < r2.end ? -1 : 1;
        }

        public String toString() {
            return "{start=" + this.start + ", end=" + this.end + "}";
        }
    }
}

