/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.excel.xssfb;

import java.util.HashMap;
import java.util.Map;

public enum XSSFBWorkbookRecordType {
    BrtFileVersion(128),
    BrtBeginBook(131),
    BrtEndBook(132),
    BrtWbProp(153),
    BrtBeginBookViews(135),
    BrtEndBookViews(136),
    BrtBeginWsView(137),
    BrtEndWsView(138),
    BrtBeginCsViews(139),
    BrtEndCsViews(140),
    BrtBeginCsView(141),
    BrtEndCsView(142),
    BrtBeginBundleShs(143),
    BrtEndBundleShs(144),
    BrtBeginSheetData(145),
    BrtEndSheetData(146),
    Unimplemented(-1);

    private static final Map<Integer, XSSFBWorkbookRecordType> TYPE_MAP;
    private final int id;

    private XSSFBWorkbookRecordType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static XSSFBWorkbookRecordType lookup(int id) {
        XSSFBWorkbookRecordType type = TYPE_MAP.get(id);
        return type == null ? Unimplemented : type;
    }

    static {
        TYPE_MAP = new HashMap<Integer, XSSFBWorkbookRecordType>();
        for (XSSFBWorkbookRecordType type : XSSFBWorkbookRecordType.values()) {
            TYPE_MAP.put(type.getId(), type);
        }
    }
}

