/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.analysis.docgen.helpers.UrlUtil;
import com.dataiku.dip.analysis.docgen.model.DocumentGenerationResponse;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.docgen.flow.FlowDocumentGenerationThread;
import com.dataiku.dip.docgen.flow.FlowDocumentUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowDocumentGenerationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private ManagedFoldersService managedFoldersService;

    public File getDefaultTemplate() {
        String templateName = "flow_documentation_template.docx";
        return DKUFileUtils.getWithin((File)new File(DKUApp.getInstallFolder(), "resources"), (String[])new String[]{"docgen", templateName});
    }

    public FutureResponse<DocumentGenerationResponse> generateDocument(DSSAuthCtx authCtx, String projectKey, InputStream inputStream) throws Exception {
        String rootUrl;
        try (Transaction ignored = this.transactionService.beginRead();){
            rootUrl = UrlUtil.getDSSInternalRootUrl(this.generalSettingsDAO.read());
        }
        return this.generateDocument(authCtx, projectKey, inputStream, rootUrl);
    }

    public FutureResponse<DocumentGenerationResponse> generateDocument(DSSAuthCtx authCtx, String projectKey, InputStream inputStream, String rootUrl) throws Exception {
        FlowDocumentGenerationThread thread = new FlowDocumentGenerationThread(authCtx, projectKey, inputStream, rootUrl);
        return this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<DocumentGenerationResponse>>(){});
    }

    public FutureResponse<DocumentGenerationResponse> generateDocumentAndWaitResponse(DSSAuthCtx authCtx, String projectKey, InputStream inputStream) throws Exception {
        FutureResponse<DocumentGenerationResponse> future = this.generateDocument(authCtx, projectKey, inputStream);
        return this.futureService.waitForFinalResponse(future);
    }

    public File generateDocumentAndWaitFile(DSSAuthCtx authCtx, String projectKey, InputStream inputStream) throws Exception {
        FutureResponse<DocumentGenerationResponse> future = this.generateDocumentAndWaitResponse(authCtx, projectKey, inputStream);
        if (((DocumentGenerationResponse)future.result).data.fatal) {
            throw new IOException("Generate document fatal error:" + String.valueOf(((DocumentGenerationResponse)future.result).data.firstFatal()));
        }
        File parentFolder = new File(MDGFileUtil.getTmpExportDirectory(((DocumentGenerationResponse)future.result).exportId));
        return FlowDocumentUtils.getRenderedTemplateFile(parentFolder);
    }

    public DocumentGenerationResponse getFdgResponse(DSSAuthCtx authCtx, String projectKey, InputStream inputStream) throws Exception {
        FutureResponse<DocumentGenerationResponse> future = this.generateDocumentAndWaitResponse(authCtx, projectKey, inputStream);
        if (((DocumentGenerationResponse)future.result).data.fatal) {
            throw new IOException("Generate document fatal error:" + String.valueOf(((DocumentGenerationResponse)future.result).data.firstFatal()));
        }
        return (DocumentGenerationResponse)future.result;
    }

    public File getFdgFile(String templateUploadId) throws IOException {
        File parentFolder = new File(MDGFileUtil.getTmpExportDirectory(templateUploadId));
        return FlowDocumentUtils.getRenderedTemplateFile(parentFolder);
    }

    public void clean(File outputFile) throws IOException {
        FileUtils.cleanDirectory((File)outputFile.getParentFile());
    }

    public File getTemplate(boolean defaultTemplate, String projectKey, String sourceFolderId, String templatePath, AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException {
        ManagedFolder source;
        if (defaultTemplate) {
            return this.getDefaultTemplate();
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            source = this.managedFoldersService.getMandatory(projectKey, sourceFolderId);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)source.buildHandler(authCtx);){
            File file = new File(handler.getAbsolutePath(templatePath));
            return file;
        }
    }
}

