/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.model;

import java.util.Objects;

public class ExportFormat {
    public PaperSize paperSize;
    public Orientation orientation;
    public FileType fileType;
    public Integer width;
    public Integer height;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportFormat that = (ExportFormat)o;
        return this.paperSize == that.paperSize && this.orientation == that.orientation && this.fileType == that.fileType && Objects.equals(this.width, that.width) && Objects.equals(this.height, that.height);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paperSize, this.orientation, this.fileType, this.width, this.height});
    }

    public static enum PaperSize {
        A4(Math.sqrt(2.0)),
        A3(Math.sqrt(2.0)),
        US_LETTER(1.2941176470588236),
        LEDGER(1.5454545454545454),
        SCREEN_16_9(1.7777777777777777, "16:9"),
        CUSTOM(null);

        public final Double ratio;
        public final String altName;

        private PaperSize(Double ratio) {
            this(ratio, null);
        }

        private PaperSize(Double ratio, String altName) {
            this.ratio = ratio;
            this.altName = altName;
        }
    }

    public static enum Orientation {
        LANDSCAPE,
        PORTRAIT;

    }

    public static enum FileType {
        PDF,
        JPEG,
        PNG;

    }
}

