/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.wikis.execution;

import java.util.Objects;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class PdfLink {
    private boolean internalLink;
    private String url;
    private String articleId;

    public boolean isInternalLink() {
        return this.internalLink;
    }

    public String getUrl() {
        return this.url;
    }

    public String getArticleId() {
        return this.articleId;
    }

    public static PdfLink articleLink(String articleId) {
        PdfLink ret = new PdfLink();
        ret.internalLink = true;
        ret.articleId = articleId;
        return ret;
    }

    public static PdfLink urlLink(String url) {
        PdfLink ret = new PdfLink();
        ret.internalLink = false;
        ret.url = url;
        return ret;
    }

    public String toString() {
        return String.format("PdfLink(internalLink: '%b', url: '%s', articleId: '%s')", this.internalLink, this.url, this.articleId);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.url).append((Object)this.articleId).append(this.internalLink).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfLink pdfLink = (PdfLink)o;
        return this.internalLink == pdfLink.internalLink && Objects.equals(this.url, pdfLink.url) && Objects.equals(this.articleId, pdfLink.articleId);
    }
}

