/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.hadoop.HDFSPathUtils;
import com.dataiku.dip.hive.HiveCodes;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreTablesHandler;
import com.dataiku.dip.hive.HiveScriptPreprocessor;
import com.dataiku.dip.hive.HiveServer2HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class HiveGlobalMetastoreTablesHandler
extends HiveMetastoreTablesHandler {
    private final List<String> commands = Lists.newArrayList();
    private final boolean forWriteByHS2;
    private static Logger logger = Logger.getLogger((String)"dku.flow.hive.globalm");

    public HiveGlobalMetastoreTablesHandler(AuthCtx authCtx, MetastoreInspectionService.MetastoreInspector hiveServer2SchemaHandler, boolean forWriteByHive) {
        super(authCtx, hiveServer2SchemaHandler);
        this.forWriteByHS2 = forWriteByHive;
    }

    @Override
    public void setHDFSPathPrefix(String prefix) {
        logger.info((Object)"Ignoring table and partition location prefix because script is using the global metastore");
    }

    @Override
    public void preProcessSource(FlowDataset fds, Dataset dataset, String tableName, List<Partition> sourceParts) throws IOException {
        if (DatasetInspector.canHDFS(dataset)) {
            try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
                this.collectedExtraConf.addAll(HiveScriptPreprocessor.getFSExtraConfForHiveserver2(handler.getFSExtraConf()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void preProcessTarget(FlowDataset fds, Dataset dataset, String tableName, Partition targetPart) throws Exception {
        this.commands.add(this.getUseDatabaseHeader(dataset, false, null));
        if (dataset.getSchema().getColumns().size() == 0) {
            return;
        }
        if (!DatasetInspector.canHDFS(dataset)) throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "Only a HDFS dataset can be used as output");
        try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            this.collectedExtraConf.addAll(HiveScriptPreprocessor.getFSExtraConfForHiveserver2(handler.getFSExtraConf()));
            HiveServer2HiveMetastoreSynchronizer synchronizer = new HiveServer2HiveMetastoreSynchronizer(this.authCtx);
            if (dataset.isManaged()) {
                synchronizer.synchronizeOneDatasetPartition(dataset, null, false, this.forWriteByHS2 ? HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_HS2_TARGET : HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.OTHER, null, true);
            } else {
                HiveServer2HiveMetastoreSynchronizer.HiveSchemaCompatibility compatibility = synchronizer.isExistingSchemaCompatible(dataset);
                if (compatibility != null) {
                    if (!compatibility.tableExists) {
                        throw new CodedException((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_UNKNOWN_TABLE, "The Hive table of " + dataset.getFullName() + " doesn't exist");
                    }
                    if (!compatibility.schemaCompatible) {
                        throw new CodedException((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_TABLE_NOT_SYNCHRONIZED, "The Hive table of " + dataset.getFullName() + " is not synchronized with the DSS schema");
                    }
                }
            }
            logger.info((Object)"Not modifying the metastore for non-managed datasets");
            if (!dataset.getPartitioningSchema().isPartitioned()) return;
            String tableLocation = handler.getFullyQualifiedRootPath();
            String finalLocation = HDFSPathUtils.concat(tableLocation, FilePartitioner.computePartitionRelPathAsFolder(targetPart, dataset.getPartitioningSchema()));
            String createPartition = this.getCreatePartition(dataset, tableName, targetPart, finalLocation);
            this.commands.add(createPartition);
            return;
        }
    }

    @Override
    public String getCreationScript() {
        return Joiner.on((String)"\n").join(this.commands);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void postProcess() {
    }

    @Override
    public boolean shouldPrefixWithDbInInsert() {
        return true;
    }
}

