/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.input.formats.AbstractJSONFormatConfig;
import com.dataiku.dip.output.StringOutputFormatter;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.json.JSONWriter;

public abstract class AbstractJSONOutputFormatter
extends StringOutputFormatter {
    protected Schema outputSchema;
    protected Writer originalWriter;
    protected JSONWriter jsonWriter;
    protected AbstractJSONFormatConfig config;

    protected AbstractJSONOutputFormatter(AbstractJSONFormatConfig config) {
        super(StandardCharsets.UTF_8.name());
        this.config = config;
    }

    public void header(ColumnFactory cf, Writer wr) throws Exception {
        if (this.config.headerRow) {
            this.checkOutputSchema();
        }
        this.setSingleJSONWriterInstance(wr);
    }

    public void format(Row row, ColumnFactory cf, Writer wr) throws Exception {
        this.checkOutputSchema();
        this.setSingleJSONWriterInstance(wr);
        this.addRow(row, cf);
    }

    public void footer(ColumnFactory cf, Writer wr) throws Exception {
        this.checkOutputSchema();
        this.setSingleJSONWriterInstance(wr);
    }

    public void cancel(OutputStream os) throws Exception {
    }

    public void setOutputSchema(Schema schema) {
        this.outputSchema = schema;
    }

    protected void addColumnNamesRow() {
        this.jsonWriter.array();
        for (SchemaColumn cs2 : this.outputSchema.columns) {
            this.jsonWriter.value((Object)cs2.getName());
        }
        this.jsonWriter.endArray();
    }

    protected void addRow(Row row, ColumnFactory cf) {
        this.jsonWriter.array();
        for (SchemaColumn cs2 : this.outputSchema.columns) {
            String v = row.get(cf.column(cs2.getName()));
            if (StringUtils.isBlank((String)v)) {
                v = "";
            }
            this.jsonWriter.value((Object)v);
        }
        this.jsonWriter.endArray();
    }

    private void setSingleJSONWriterInstance(Writer wr) {
        if (this.originalWriter == null) {
            this.originalWriter = wr;
            this.jsonWriter = new JSONWriter((Appendable)wr);
        } else if (wr != this.originalWriter) {
            throw new IllegalArgumentException("Cannot write in several writers from the same " + ((Object)((Object)this)).getClass().getName());
        }
    }

    private void checkOutputSchema() {
        if (this.outputSchema == null) {
            throw new IllegalStateException("Formatter needs an output schema");
        }
        if (this.outputSchema.columns.size() == 0) {
            throw new IllegalStateException("Output schema is empty");
        }
    }
}

