/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.math.DoubleMath;
import java.io.InputStream;
import java.util.ArrayList;
import org.eobjects.sassy.SasColumnType;
import org.eobjects.sassy.SasReader;
import org.eobjects.sassy.SasReaderCallback;

public class SASFormatExtractor
extends ArchiveCapableFormatExtractor {
    public static final FormatMeta<SASFormatExtractor, Config> META = new FormatMeta<SASFormatExtractor, Config>(){

        @Override
        public String getType() {
            return "sas";
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return Config.class;
        }

        @Override
        public SASFormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new SASFormatExtractor();
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            throw new NotImplementedException();
        }

        @Override
        public String getLabel() {
            return "SAS database";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.TEXT_POSITION_BASED_VARIABLE_COLUMNS;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[]{FormatFactory.getStandardCompressionMethods()};
        }
    };

    @Override
    protected boolean doExtractStream(InputStreamWithContextInfo isn, final ProcessorOutput out, final ColumnFactory cf, final RowFactory rf, final ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        InputStream is = isn.getInputStream();
        SasReader reader = new SasReader(is, "SAS File");
        final ArrayList columns = new ArrayList();
        class SASReadData
        implements SasReaderCallback {
            Exception e;
            int rowCount;

            SASReadData() {
            }

            public void column(int index, String columnName, String columnLogicalName, SasColumnType sasColumnType, int columnLength) {
                Column column = cf.column(columnName);
                columns.add(index, column);
            }

            public boolean readData() {
                return true;
            }

            public boolean row(int i, Object[] objects) {
                if (!observer.checkLimit(this.rowCount)) {
                    return false;
                }
                try {
                    Row row = rf.row();
                    for (int j = 0; j < objects.length; ++j) {
                        Column column = (Column)columns.get(j);
                        Object o = objects[j];
                        if (o instanceof String) {
                            row.put(column, (String)o);
                            continue;
                        }
                        if (o instanceof Double) {
                            Double val = (Double)o;
                            if (val != null && DoubleMath.isMathematicalInteger((double)val)) {
                                row.put(column, val.longValue());
                                continue;
                            }
                            row.put(column, ((Double)o).doubleValue());
                            continue;
                        }
                        if (o instanceof Integer) {
                            row.put(column, ((Integer)o).intValue());
                            continue;
                        }
                        if (o instanceof Short) {
                            row.put(column, (int)((Short)o).shortValue());
                            continue;
                        }
                        if (o instanceof Byte) {
                            row.put(column, (int)((Byte)o).byteValue());
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid type " + String.valueOf(o.getClass()));
                    }
                    out.emitRow(row);
                    ++this.rowCount;
                    if (this.rowCount % 500 == 0) {
                        observer.onInterval(this.rowCount);
                    }
                    return true;
                }
                catch (Exception e) {
                    this.e = e;
                    return false;
                }
            }
        }
        SASReadData rd = new SASReadData();
        reader.read((SasReaderCallback)rd);
        if (rd.e != null) {
            throw rd.e;
        }
        observer.onEnd(rd.rowCount);
        return true;
    }

    public static class Config
    implements FormatParams {
    }
}

