/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.labeling.Annotation;
import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.LabelingRecord;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.labeling.consensus.ConsensualCommentComputer;
import com.dataiku.dip.labeling.region.LabelingRegion;
import com.dataiku.dip.labeling.region.LabelingRegionDispatcherFactory;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@UIModel
public class ReviewRecordInfo {
    public final String id;
    public final LabelingRecord record;
    @Nullable
    public final VerifiedLabelingAnswer verifiedAnswer;
    public final List<? extends LabelingRegion<? extends Annotation>> regions;
    public final Map<String, String> comments;
    public final boolean commentConflict;
    public final String commentSuggestion;

    public ReviewRecordInfo(LabelingTask task, LabelingRecord record, @Nullable VerifiedLabelingAnswer verifiedAnswer, List<LabelingAnswer> answers) {
        this.record = record;
        this.id = record.id;
        this.verifiedAnswer = verifiedAnswer;
        this.regions = LabelingRegionDispatcherFactory.getDispatcher(task).dispatch(answers);
        this.comments = LabelingAnswer.extractComments(answers);
        ConsensualCommentComputer.Result consensualComment = new ConsensualCommentComputer(task.commentSettings.autoValidateStrategy).compute(this.comments);
        this.commentConflict = consensualComment.conflict;
        this.commentSuggestion = consensualComment.comment;
    }
}

