/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.entityextraction;

import com.dataiku.dip.labeling.BaseLabelingAnswer;
import com.dataiku.dip.labeling.entityextraction.NamedEntity;
import com.dataiku.dip.labeling.region.LabelingRegion;
import com.dataiku.dip.labeling.region.LabelingRegionDispatcher;
import com.dataiku.dip.labeling.region.RegionElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SimpleEntityExtractionRegionDispatcher
extends LabelingRegionDispatcher<NamedEntity> {
    @Override
    protected List<LabelingRegion<NamedEntity>> buildRegions(List<? extends BaseLabelingAnswer> answers) {
        List regionElements = this.flattenedRegionElementsFromAnswers(answers);
        regionElements = regionElements.stream().sorted((re1, re2) -> (int)(((NamedEntity)re1.annotation).beginningIndex - ((NamedEntity)re2.annotation).beginningIndex)).collect(Collectors.toList());
        ArrayList regions = new ArrayList();
        LabelingRegion currentRegion = null;
        Long lastAnnotationIdxInCurrentRegion = null;
        for (RegionElement currentRegionElement : regionElements) {
            if (lastAnnotationIdxInCurrentRegion == null) {
                currentRegion = new LabelingRegion(currentRegionElement);
                lastAnnotationIdxInCurrentRegion = ((NamedEntity)currentRegionElement.annotation).endIndex;
                continue;
            }
            if (((NamedEntity)currentRegionElement.annotation).beginningIndex <= lastAnnotationIdxInCurrentRegion) {
                currentRegion.elements.add(currentRegionElement);
                lastAnnotationIdxInCurrentRegion = Math.max(((NamedEntity)currentRegionElement.annotation).endIndex, lastAnnotationIdxInCurrentRegion);
                continue;
            }
            if (currentRegion.elements.size() > 0) {
                regions.add(currentRegion);
            }
            currentRegion = new LabelingRegion(currentRegionElement);
            lastAnnotationIdxInCurrentRegion = ((NamedEntity)currentRegionElement.annotation).endIndex;
        }
        if (currentRegion != null && currentRegion.elements.size() > 0) {
            regions.add(currentRegion);
        }
        ArrayList<LabelingRegion<NamedEntity>> regionsListAfterExtractions = new ArrayList<LabelingRegion<NamedEntity>>(regions);
        for (LabelingRegion labelingRegion : regions) {
            List<LabelingRegion<NamedEntity>> newRegions = this.extractNonConflictingElementsToNewRegions(labelingRegion, answers.size());
            regionsListAfterExtractions.addAll(newRegions);
        }
        return regionsListAfterExtractions;
    }

    private List<LabelingRegion<NamedEntity>> extractNonConflictingElementsToNewRegions(LabelingRegion<NamedEntity> region, int totalNbAnswers) {
        List<List<RegionElement<NamedEntity>>> notConflictingElements = this.listNonConflictingElementsInRegion(region, totalNbAnswers);
        int notConflictingElementsCount = notConflictingElements.stream().mapToInt(List::size).sum();
        if (notConflictingElementsCount == region.elements.size()) {
            notConflictingElements.remove(0);
        }
        List elementIdsToRemove = notConflictingElements.stream().flatMap(Collection::stream).map(e -> e.id).collect(Collectors.toList());
        region.elements = region.elements.stream().filter(e -> !elementIdsToRemove.contains(e.id)).collect(Collectors.toList());
        return notConflictingElements.stream().map(LabelingRegion::new).collect(Collectors.toList());
    }

    @Override
    protected boolean computeConflict(LabelingRegion<NamedEntity> region, int totalNbAnswers) {
        return region.elements.size() < totalNbAnswers || !region.elements.stream().allMatch(entity -> ((NamedEntity)entity.annotation).equals(region.elements.get((int)0).annotation));
    }

    private List<List<RegionElement<NamedEntity>>> listNonConflictingElementsInRegion(LabelingRegion<NamedEntity> region, int totalNbAnswers) {
        Collection<List<RegionElement>> sameAnnotationsList = region.elements.stream().collect(Collectors.groupingBy(r -> (NamedEntity)r.annotation)).values();
        return sameAnnotationsList.stream().filter(sameAnnotations -> sameAnnotations.size() >= totalNbAnswers).collect(Collectors.toList());
    }
}

