/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.vertex.api;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import com.dataiku.dip.llm.online.vertex.api.GeminiQuery;
import com.dataiku.dip.llm.online.vertex.api.GeminiResponse;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GeminiResponseAdapter {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.vertex.gemini");

    public static LLMClient.SimpleCompletionResponse adapt(GeminiResponse.ChatResponses rcrs) {
        LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
        if (rcrs.stream().anyMatch(r -> r.candidates.size() > 1)) {
            logger.warn((Object)"Received a response containing multiple candidates. Ignoring all but the first candidate.");
        }
        List validCandidates = rcrs.stream().filter(r -> !r.candidates.isEmpty()).map(r -> r.candidates.get(0)).collect(Collectors.toList());
        ret.text = validCandidates.stream().map(c2 -> c2.content.parts.stream().filter(p -> p.thought == null || p.thought == false).map(p -> p.text).filter(Objects::nonNull).collect(Collectors.joining("\n\n"))).collect(Collectors.joining());
        List<String> reasoningSummary = validCandidates.stream().map(c2 -> c2.content.parts.stream().filter(p -> p.thought != null && p.thought != false).map(p -> p.text).filter(Objects::nonNull).collect(Collectors.joining("\n\n"))).filter(p -> !p.isEmpty()).toList();
        if (!reasoningSummary.isEmpty()) {
            if (ret.artifacts == null) {
                ret.artifacts = new ArrayList<LLMClient.Artifact>();
            }
            LLMClient.Artifact reasoningArtifact = new LLMClient.Artifact();
            reasoningArtifact.type = "REASONING";
            for (String reasoning : reasoningSummary) {
                if (reasoning.isEmpty()) continue;
                LLMClient.SourceItem sourceItem = new LLMClient.SourceItem();
                sourceItem.type = "TEXT";
                sourceItem.text = reasoning;
                reasoningArtifact.parts.add(sourceItem);
            }
            ret.artifacts.add(reasoningArtifact);
        }
        ret.toolCalls = validCandidates.stream().map(c2 -> c2.content.parts.stream().map(p -> p.functionCall).filter(Objects::nonNull).map(GeminiResponseAdapter::adapt).collect(Collectors.toList())).collect(Collectors.toList()).stream().flatMap(Collection::stream).collect(Collectors.toList());
        for (GeminiResponse.ChatCandidate c3 : validCandidates) {
            String reason = c3.finishReason;
            if (reason == null) continue;
            ret.finishReason = FinishReasonResponseAdapter.adapt(reason);
        }
        ret.promptTokens = rcrs.stream().mapToInt(r -> r.usageMetadata.promptTokenCount).sum();
        ret.completionTokens = rcrs.stream().mapToInt(r -> r.usageMetadata.candidatesTokenCount).sum();
        LLMClient.SimpleCompletionResponse simpleCompletionResponse = ret;
        simpleCompletionResponse.completionTokens = simpleCompletionResponse.completionTokens + rcrs.stream().mapToInt(r -> r.usageMetadata.thoughtsTokenCount).sum();
        ret.totalTokens = rcrs.stream().mapToInt(r -> r.usageMetadata.totalTokenCount).sum();
        return ret;
    }

    private static LLMClient.AbstractToolCall adapt(GeminiQuery.FunctionCall tc) {
        LLMClient.FunctionToolCallInfo function = new LLMClient.FunctionToolCallInfo();
        function.name = tc.name;
        if (tc.args != null) {
            function.arguments = JSON.json((Object)tc.args);
        }
        LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
        ftc.id = tc.name;
        ftc.function = function;
        return ftc;
    }
}

