/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.cache;

import com.dataiku.dip.utils.DKULogger;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;

public class LRUList<T>
implements Iterable<T> {
    private int size;
    private ArrayList<SoftReference<T>> data = new ArrayList();
    private static DKULogger logger = DKULogger.getLogger(LRUList.class);

    public LRUList(int size) {
        this.size = size;
    }

    public synchronized void addAndCollect(T elm) {
        this.cleanup();
        boolean redo = true;
        while (redo) {
            redo = false;
            int currentPos = -1;
            for (int i = 0; i < this.data.size(); ++i) {
                if (elm != this.data.get(i)) continue;
                currentPos = i;
                break;
            }
            if (currentPos == -1) continue;
            this.data.remove(currentPos);
            redo = true;
        }
        this.data.add(new SoftReference<T>(elm));
        while (this.data.size() > this.size) {
            this.data.remove(0);
        }
    }

    public synchronized int cleanup() {
        int gced = 0;
        Iterator<SoftReference<T>> it = this.data.iterator();
        while (it.hasNext()) {
            if (it.next().get() != null) continue;
            it.remove();
            ++gced;
        }
        if (gced > 0) {
            logger.debug((Object)("Cache entries evicted by GC: " + gced));
        }
        return gced;
    }

    @Override
    public synchronized Iterator<T> iterator() {
        this.cleanup();
        ArrayList<T> copiedList = new ArrayList<T>();
        for (SoftReference<T> ref : this.data) {
            T item = ref.get();
            if (item == null) continue;
            copiedList.add(item);
        }
        return copiedList.iterator();
    }
}

