/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.plugins.IPluginSettingsDAO;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class FileBasedPluginSettingsDAO
implements IPluginSettingsDAO {
    static Logger logger = Logger.getLogger((String)"dku.plugins.settings");

    @Override
    public PluginSettings getSettings(String pluginId) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return (PluginSettings)t.readObjectDefault(this.pluginSettingsFile(pluginId), PluginSettings.class);
    }

    @Override
    public PluginSettings getProjectSettings(String pluginId, String projectKey) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return (PluginSettings)t.readObjectDefault(this.pluginSettingsFile(pluginId, projectKey), PluginSettings.class);
    }

    @Override
    public void removeSettings(String pluginId) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        tr.deleteFile(this.pluginSettingsFile(pluginId));
    }

    @Override
    public void setSettings(String pluginId, PluginSettings settings) throws IOException {
        assert (settings != null);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        tr.writeObject(this.pluginSettingsFile(pluginId), (Object)settings);
    }

    public void setProjectSettings(String pluginId, String projectKey, PluginSettings settings) throws IOException {
        assert (settings != null);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        tr.writeObject(this.pluginSettingsFile(pluginId, projectKey), (Object)settings);
    }

    private RelFile pluginSettingsFile(String pluginId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)pluginId), (Object)"Plugin id is not specified");
        return new RelFile(new String[]{"plugins", pluginId, "settings.json"});
    }

    private RelFile pluginSettingsFile(String pluginId, String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)pluginId), (Object)"Plugin id is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "plugins", pluginId, "settings.json"});
    }
}

