/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.populardatasets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoint;

public class TrendingDetector {
    private final long now;
    private final long windowSize;
    private final double recentTrendTolerance;
    private final double trendPseudoLinearQuadraticThreshold;
    private final double trendPseudoLinearSlopeThreshold;
    private final int[] creationsByWindow;

    public TrendingDetector(long now, long windowSize, double recentTrendTolerance, double trendPseudoLinearQuadraticThreshold, double trendPseudoLinearSlopeThreshold, int maxWindowCount) {
        this.now = now;
        this.windowSize = windowSize;
        this.recentTrendTolerance = recentTrendTolerance;
        this.trendPseudoLinearQuadraticThreshold = trendPseudoLinearQuadraticThreshold;
        this.trendPseudoLinearSlopeThreshold = trendPseudoLinearSlopeThreshold;
        this.creationsByWindow = new int[maxWindowCount];
        this.reset();
    }

    public void reset() {
        Arrays.fill(this.creationsByWindow, 0);
    }

    public int addCreationDate(long timestamp) {
        int windowId = Math.toIntExact((this.now - timestamp) / this.windowSize);
        if (windowId < this.creationsByWindow.length) {
            int n = windowId;
            this.creationsByWindow[n] = this.creationsByWindow[n] + 1;
        }
        return windowId;
    }

    private List<WeightedObservedPoint> prepareNoTailList() {
        int lastNonZeroIdx = -1;
        for (int i = 0; i < this.creationsByWindow.length; ++i) {
            if (this.creationsByWindow[i] <= 0) continue;
            lastNonZeroIdx = i;
        }
        ArrayList<WeightedObservedPoint> preprocessedValues = new ArrayList<WeightedObservedPoint>(lastNonZeroIdx + 1);
        for (int i = 0; i <= lastNonZeroIdx; ++i) {
            preprocessedValues.add(new WeightedObservedPoint(1.0, (double)i, (double)this.creationsByWindow[i]));
        }
        return preprocessedValues;
    }

    public boolean isTrending() {
        List<WeightedObservedPoint> preprocessedValues = this.prepareNoTailList();
        if (preprocessedValues.size() < 3) {
            return false;
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)2);
        double[] coeffs = fitter.fit(preprocessedValues);
        if (Math.abs(coeffs[2]) < this.trendPseudoLinearQuadraticThreshold) {
            return coeffs[1] < this.trendPseudoLinearSlopeThreshold;
        }
        double extremumAbciss = -coeffs[1] / (2.0 * coeffs[2]);
        return coeffs[2] > 0.0 ? extremumAbciss >= this.recentTrendTolerance : extremumAbciss <= this.recentTrendTolerance;
    }
}

