/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.remoterun;

import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class IntercomClientBuilder {
    private static Logger logger = Logger.getLogger((String)"dku.remoterun.api");

    public static String getIntercomAPIPath() {
        String serverKind = RemoteRunEnvHelper.getEnv("DKU_SERVER_KIND");
        if ("JEK".equals(serverKind)) {
            return "kernel/tintercom";
        }
        return "dip/api/tintercom";
    }

    public static TicketBasedIntercomAPIClient build() throws UnknownHostException {
        String protocol;
        String portStr;
        String host;
        String serverKind = RemoteRunEnvHelper.getEnv("DKU_SERVER_KIND");
        if ("JEK".equals(serverKind)) {
            host = RemoteRunEnvHelper.getEnv("DKU_SERVER_HOST");
            portStr = RemoteRunEnvHelper.getEnv("DKU_SERVER_PORT");
            protocol = RemoteRunEnvHelper.getEnv("DKU_SERVER_PROTOCOL");
        } else {
            host = RemoteRunEnvHelper.getEnv("DKU_BACKEND_HOST");
            portStr = RemoteRunEnvHelper.getEnv("DKU_BACKEND_PORT");
            protocol = RemoteRunEnvHelper.getEnv("DKU_BACKEND_PROTOCOL");
        }
        String cert = RemoteRunEnvHelper.getEnv("DKU_SERVER_CERT");
        if (host == null) {
            host = InetAddress.getLocalHost().getHostName();
        }
        if (RemoteRunEnvHelper.getEnv("DKU_TUNNEL_HOST") != null) {
            host = RemoteRunEnvHelper.getEnv("DKU_TUNNEL_HOST");
        }
        if (RemoteRunEnvHelper.getEnv("DKU_TUNNEL_PORT") != null) {
            portStr = RemoteRunEnvHelper.getEnv("DKU_TUNNEL_PORT");
        }
        int port = portStr == null ? 0 : Integer.parseInt(portStr);
        logger.info((Object)("Creating API client with protocol=" + protocol + " host=" + host + " port=" + port));
        return new TicketBasedIntercomAPIClient(protocol + "://" + host + ":" + port, cert, RemoteRunEnvHelper.getEnv("DKU_API_TICKET"));
    }
}

