/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.reports;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Report
extends TaggableObjectsService.TaggableObject
implements MetaWithSelectableCodeEnv {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public ReportParams params;
    public String name;
    private static final String HTML = "text/html";
    private static final String PDF = "application/pdf";
    private static final String PLAIN = "text/plain";
    private static final String DOCX = "application/docx";
    private static final String ODT = "application/odt";
    private static final String RTF = "application/rtf";

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.REPORT;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.R;
    }

    public static enum ReportOutputFormat {
        HTML_DOCUMENT("html_document", "html", "text/html"),
        PDF_DOCUMENT("pdf_document", "pdf", "application/pdf"),
        HTML_NOTEBOOK("html_notebook", "nb.html", "text/html"),
        WORD_DOCUMENT("word_document", "docx", "application/docx"),
        ODT_DOCUMENT("odt_document", "odt", "application/odt"),
        RTF_DOCUMENT("rtf_document", "rtf", "application/rtf"),
        IOSLIDES_PRESENTATION("ioslides_presentation", "ioslides.html", "text/html"),
        REVEALJS_PRESENTATION("revealjs::revealjs_presentation", "revealjs.html", "text/html"),
        SLIDY_PRESENTATION("slidy_presentation", "slidy.html", "text/html"),
        BEAMER_PRESENTATION("beamer_presentation", "beamer.pdf", "application/pdf"),
        FLEX_DASHBOARD("flexdashboard::flex_dashboard", "flex.html", "text/html"),
        TUFTE_HANDOUT("tufte::tufte_handout", "tufte.pdf", "application/pdf"),
        TUFTE_HTML("tufte::tufte_html", "tufte.html", "text/html"),
        TUFTE_BOOK("tufte::tufte_book", "tufte.pdf", "application/pdf"),
        HTML_VIGNETTE("html_vignette", "vignette.html", "text/html");

        String name;
        private String extension;
        private String contentType;

        private ReportOutputFormat(String name, String extension, String contentType) {
            this.name = name;
            this.extension = extension;
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getExtension() {
            return this.extension;
        }

        public static ReportOutputFormat getDefaultFormat() {
            return HTML_DOCUMENT;
        }

        public static Map<String, Boolean> getDefaultSnapshotFormats() {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put(HTML_DOCUMENT.toString(), true);
            map.put(PDF_DOCUMENT.toString(), true);
            return map;
        }

        public static ReportOutputFormat getByExtension(String ext) {
            for (ReportOutputFormat format : ReportOutputFormat.values()) {
                if (!format.extension.equals(ext)) continue;
                return format;
            }
            return null;
        }
    }

    public static class ReportParams
    implements ParamsWithSelectableCodeEnv {
        public ReportOutputFormat viewFormat = ReportOutputFormat.getDefaultFormat();
        public Map<String, Boolean> snapshotFormats = ReportOutputFormat.getDefaultSnapshotFormats();
        public boolean buildOnSave;
        public CodeEnvSelection envSelection = new CodeEnvSelection();

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.R, this.envSelection.envName, CodeEnvModel.EnvUsage.REPORT, object.getProjectKey(), object.getId()));
            }
            return usages;
        }
    }

    public static class ReportSummary
    extends TaggableObjectsService.TaggableObjectSummary {
        public String script;
    }

    public static class ReportListItem
    extends TaggableObjectsService.TaggableListItem {
        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.REPORT;
        }

        public ReportListItem(Report report) {
            super(report);
        }
    }
}

