/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.agents.tools.AgentToolsRegistry;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.savedmodels.agents.AgentTypesRegistry;
import com.dataiku.dip.savedmodels.agents.CustomAgentDependenciesCollector;
import com.dataiku.dip.savedmodels.agents.CustomAgentMeta;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SavedModelsAgentsBaseService {
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    static DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.service");

    public static SavedModel.SavedModelInlineVersion getActiveOrLatestInlineVersion(SavedModel sm) {
        if (sm.inlineVersions == null || sm.inlineVersions.size() == 0) {
            return null;
        }
        Optional<Object> ret = Optional.empty();
        if (sm.activeVersion != null) {
            ret = sm.getVersion(sm.activeVersion);
        }
        if (ret.isPresent()) {
            return (SavedModel.SavedModelInlineVersion)ret.get();
        }
        ret = sm.inlineVersions.stream().min((o1, o2) -> -o1.versionId.compareTo(o2.versionId));
        return ret.orElse(null);
    }

    public List<SavedModel.AgentDependency> getDependencies(SavedModel sm) throws IOException {
        List<SavedModel.AgentDependency> ret = new ArrayList<SavedModel.AgentDependency>();
        if (sm.savedModelType == null) {
            return ret;
        }
        SavedModel.SavedModelInlineVersion smiv = SavedModelsAgentsBaseService.getActiveOrLatestInlineVersion(sm);
        if (smiv == null) {
            return ret;
        }
        switch (sm.savedModelType) {
            case PYTHON_AGENT: {
                ret = smiv.pythonAgentSettings.dependencies;
                break;
            }
            case PLUGIN_AGENT: {
                CustomAgentMeta meta = AgentTypesRegistry.getMeta(smiv.pluginAgentType);
                ret.addAll(CustomAgentDependenciesCollector.collect(meta.getAgentDesc().params, smiv.pluginAgentConfig));
                break;
            }
            case TOOLS_USING_AGENT: {
                for (SavedModel.UsedTool ut : smiv.toolsUsingAgentSettings.tools) {
                    AgentToolMeta atm;
                    AgentTool at = (AgentTool)this.agentToolsDAO.getOrNullUnsafe(AnyLoc.resolveSmart(sm.projectKey, ut.toolRef));
                    if (at == null || (atm = AgentToolsRegistry.getMeta(at.type)) == null) continue;
                    ret.addAll(atm.getDependencies(at));
                }
                break;
            }
        }
        return ret;
    }
}

