/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedScenariosDAO
extends AbstractStandardDAO<Scenario>
implements ScenariosDAO {
    protected static final String EXTENSION = "json";

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.SCENARIO.toHumanReadableString();
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile rf;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(rf = this.getScenariosFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(rf, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    protected List<Scenario> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList ret = Lists.newArrayList();
        RelFile scenariosFolder = this.getScenariosFolder(projectKey);
        if (!t.exists(scenariosFolder)) {
            return ret;
        }
        for (RelFile f : t.listFiles(scenariosFolder, (RelFileFilter)FileFilter.json())) {
            String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
            try {
                Scenario sc = this.getOrNull_noTag(projectKey, id, unsafe);
                ret.add(sc);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Error in scenario file:" + String.valueOf(f)), (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    protected Scenario getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile file;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(file = this.getDAOFile(projectKey, id))) {
            return null;
        }
        Scenario sc = unsafe ? (Scenario)t.readObjectUnsafe(file, Scenario.class) : (Scenario)t.readObject(file, Scenario.class);
        sc.withId(id).withProjectKey(projectKey);
        return sc;
    }

    @Override
    public void delete(String projectKey, String scenarioId) throws IOException {
        RelFile file;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.isFile(file = this.getDAOFile(projectKey, scenarioId))) {
            throw new NotFoundException("Scenario does not exist: " + projectKey + "." + scenarioId);
        }
        t.deleteFile(file);
    }

    @Override
    public void deletePayload(String projectKey, String scenarioId, String extension) throws IOException {
        RelFile file;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.isFile(file = this.getModelFile(projectKey, scenarioId, extension))) {
            t.deleteFile(file);
        }
    }

    @Override
    public void save(String projectKey, String scenarioId, Scenario data) throws IOException {
        RelFile file;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.isFile(file = this.getDAOFile(projectKey, scenarioId)) && data == null) {
            data = (Scenario)t.readObject(file, Scenario.class);
        } else if (data == null) {
            throw ErrorContext.iae((String)"Scenario data not given, and no previous version exists");
        }
        super.save(data);
    }

    @Override
    public String getPayload(String projectKey, String scenarioId, String extension) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile file = this.getModelFile(projectKey, scenarioId, extension);
        this.logger.info((Object)("Reading payload file " + String.valueOf(file)));
        if (!t.isFile(file)) {
            return null;
        }
        return t.readStringUTF8(file);
    }

    @Override
    public void savePayload(String projectKey, String scenarioId, String extension, String data) throws IOException {
        RelFile file;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.isFile(file = this.getModelFile(projectKey, scenarioId, extension)) && data == null) {
            data = t.readStringUTF8(file);
        } else if (data == null) {
            throw ErrorContext.iae((String)"Script data not given, and no previous version exists");
        }
        t.writeStringUTF8(file, data);
    }

    private RelFile getScenariosFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "scenarios"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String scenarioId) {
        return this.getModelFile(projectKey, scenarioId, EXTENSION);
    }

    protected RelFile getModelFile(String projectKey, String scenarioId, String extension) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)scenarioId), (Object)"Scenario id is not specified");
        return new RelFile(this.getScenariosFolder(projectKey), new String[]{scenarioId + "." + extension});
    }
}

