/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.reports;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationHooksRegistry;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.scheduler.reports.DistillationUnit;
import com.dataiku.dip.scheduler.reports.FirstItemDistillation;
import com.dataiku.dip.scheduler.reports.ItemCountDistillation;
import com.dataiku.dip.scheduler.reports.ItemFieldDistillation;
import com.dataiku.dip.scheduler.reports.ItemsSummaryDistillation;
import com.dataiku.dip.scheduler.reports.MessageLookupBuilder;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.reports.ScenarioReportEvent;
import com.dataiku.dip.scheduler.reports.ScenarioReporter;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.services.ScenarioReportsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.PythonInterpreterFactory;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.springframework.beans.factory.annotation.Autowired;

public class ScenarioReporterRunner {
    private static String PYTHON_FUNCTION_NAME = "get_variables";
    public static final String SCENARIORUN_LOGFILE_VAR = "scenarioRunLogFile";
    public static final ReporterRunnerBuilder META = new ReporterRunnerBuilder(){

        @Override
        public ScenarioReporterRunner build(ScenarioReporter reporter, ScenarioRun scenarioRun, Scenario scenario) {
            ScenarioReporterRunner runner = new ScenarioReporterRunner(reporter, scenarioRun, scenario);
            SpringUtils.getInstance().autowire((Object)runner);
            return runner;
        }
    };
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private ScenarioReportsService scenarioReportsService;
    @Autowired
    private TransactionService transactionService;
    private final ScenarioRun scenarioRun;
    private final ScenarioReporter reporter;
    private final Scenario scenario;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.reporter");

    public static ScenarioReporterRunner build(ScenarioReporter reporter, ScenarioRun scenarioRun, Scenario scenario) {
        return META.build(reporter, scenarioRun, scenario);
    }

    ScenarioReporterRunner(ScenarioReporter reporter, ScenarioRun scenarioRun, Scenario scenario) {
        this.scenarioRun = scenarioRun;
        this.scenario = scenario;
        this.reporter = reporter;
    }

    public ScenarioReporter getReporter() {
        return this.reporter;
    }

    public InfoMessage.InfoMessages sendOnStart() throws Exception {
        if (this.reporter.phase == ScenarioReporter.Phase.START) {
            logger.info((Object)("Report on scenario start " + this.scenario.getName() + " by reporter " + this.reporter.getName()));
            return this.sendMessage(null);
        }
        return null;
    }

    public InfoMessage.InfoMessages sendOnEnd() throws Exception {
        if (this.reporter.phase == ScenarioReporter.Phase.END) {
            logger.info((Object)("Report on scenario finish" + this.scenario.getName() + " by reporter " + this.reporter.getName()));
            String runCondition = this.reporter.isRunConditionEnabled() ? this.reporter.getRunCondition() : null;
            return this.sendMessage(runCondition);
        }
        return null;
    }

    public InfoMessage.InfoMessages sendMessage(String runCondition) throws Exception {
        List<ReportItem> allItems;
        IntegrationHook messaging = this.reporter.getMessaging();
        List<DistillationUnit> distillationUnits = this.allDistillationUnits();
        List<StepRun> stepRuns = this.scenariosService.getStepRunsOfRun(this.scenarioRun);
        try (Transaction t = this.transactionService.beginRead();){
            allItems = this.scenarioReportsService.listReportItems(this.scenario.getProjectKey(), this.scenarioRun, stepRuns);
        }
        for (ReportItem item : allItems) {
            for (DistillationUnit unit : distillationUnits) {
                unit.handle(item);
            }
        }
        MessageLookupBuilder lookupBuilder = new MessageLookupBuilder();
        VariableLookup lookup = lookupBuilder.build(this.scenario.getProjectKey(), distillationUnits, this.scenario, this.scenarioRun);
        if (!StringUtils.isBlank((String)this.reporter.getVariablesCode())) {
            this.runCustomVariablesCode(lookup, this.reporter.getVariablesCode(), allItems, stepRuns);
        }
        lookup.addVariable("scenarioName", this.scenario.getName());
        lookup.addVariable("scenarioId", this.scenario.getId());
        lookup.addVariable("scenarioProjectKey", this.scenario.getProjectKey());
        File logFile = ScenarioRunContext.getLog(this.scenarioRun);
        if (logFile.exists()) {
            lookup.addVariable(SCENARIORUN_LOGFILE_VAR, logFile);
        }
        if (StringUtils.isNotBlank((String)runCondition)) {
            String runApproved = lookup.lookup(runCondition);
            if (StringUtils.isBlank((String)runApproved) || !Boolean.parseBoolean(runApproved)) {
                logger.info((Object)("Not sending message because run condition not met (evaluated to ' " + runApproved + "')"));
                return null;
            }
            logger.info((Object)("Run condition met: " + runApproved));
        } else {
            logger.info((Object)"Unconditional send");
        }
        IntegrationEventHandler sender = IntegrationHooksRegistry.buildSender(this.scenarioRun.getRunAsUser(), messaging, new IntegrationMeta.PermissionCheckContext(true));
        logger.info((Object)"Start sending message");
        ScenarioReportEvent sre = new ScenarioReportEvent();
        sre.lookup = lookup;
        sre.projectKey = this.scenarioRun.getScenario().getProjectKey();
        InfoMessage.InfoMessages outcome = new InfoMessage.InfoMessages();
        sender.handleEvent(sre, outcome);
        logger.info((Object)"Done sending message");
        return outcome;
    }

    private List<DistillationUnit> allDistillationUnits() {
        ArrayList<DistillationUnit> allUnits = new ArrayList<DistillationUnit>();
        allUnits.add(new ItemFieldDistillation(ReportItem.TriggerFired.class, ReportTargetItem.ScenarioTriggerItem.class, "name", "triggerName"));
        allUnits.add(new ItemFieldDistillation(ReportItem.TriggerFired.class, ReportTargetItem.ScenarioTriggerItem.class, "type", "triggerType"));
        allUnits.add(new ItemsSummaryDistillation(null, "allEventsSummary"));
        allUnits.add(new ItemsSummaryDistillation(ReportItem.Outcome.FAILED, "failedEventsSummary"));
        allUnits.add(new ItemsSummaryDistillation(ReportItem.Outcome.WARNING, "warningsEventsSummary"));
        allUnits.add(new ItemCountDistillation(ReportItem.StepDone.class, "Steps"));
        allUnits.add(new ItemCountDistillation(ReportItem.JobExecuted.class, "Jobs"));
        allUnits.add(new ItemCountDistillation(ReportItem.CheckedDataset.class, "CheckedDatasets"));
        allUnits.add(new ItemCountDistillation(ReportItem.BuiltDataset.class, "BuiltDatasets"));
        allUnits.add(new ItemCountDistillation(ReportItem.BuiltManagedFolder.class, "BuiltFolders"));
        allUnits.add(new ItemCountDistillation(ReportItem.BuiltSavedModel.class, "TrainedModels"));
        allUnits.add(new ItemCountDistillation(ReportItem.CreatedJupyterExport.class, "RefreshedNotebooks"));
        allUnits.add(new ItemCountDistillation(ReportItem.HiveMetastoreSynchronized.class, "SyncedHiveTables"));
        allUnits.add(new ItemCountDistillation(ReportItem.ComputedMetrics.class, "ComputedMetrics"));
        allUnits.add(new ItemCountDistillation(ReportItem.CodeExecuted.class, "ScriptRuns"));
        allUnits.add(new FirstItemDistillation(ReportItem.StepDone.class, ReportItem.Outcome.FAILED, "firstFailedStep"));
        allUnits.add(new FirstItemDistillation(ReportItem.JobExecuted.class, ReportItem.Outcome.FAILED, "firstFailedJob"));
        return allUnits;
    }

    private void runCustomVariablesCode(VariableLookup lookup, String updateCode, List<ReportItem> items, List<StepRun> stepRuns) {
        logger.info((Object)"Creating Python interpreter for variables computation");
        try (PythonInterpreter interpreter = PythonInterpreterFactory.newInstance(true);){
            PyObject variablesObj;
            interpreter.exec(updateCode);
            PyObject entryPoint = interpreter.get(PYTHON_FUNCTION_NAME);
            if (!(entryPoint instanceof PyFunction)) {
                throw ErrorContext.iaef((String)"Function %s not found in variables update code", (Object)PYTHON_FUNCTION_NAME, (Object[])new Object[0]);
            }
            PyFunction entryPointFunction = (PyFunction)entryPoint;
            int argCount = entryPointFunction.__getattr__("func_code").__getattr__("co_argcount").asInt();
            ArrayList args = Lists.newArrayList();
            if (argCount > 0) {
                args.add(Py.newStringOrUnicode((String)JSON.json(items)));
            }
            if (argCount > 1) {
                args.add(Py.newStringOrUnicode((String)JSON.json((Object)this.scenarioRun)));
            }
            if (argCount > 2) {
                HashMap stepRunData = Maps.newHashMap();
                Map<String, Object> stepRunOutputs = this.scenarioRun.getStepRunOutputs();
                for (StepRun stepRun : stepRuns) {
                    if (!StringUtils.isNotBlank((String)stepRun.getStep().getName()) || !stepRunOutputs.containsKey(stepRun.getRunId())) continue;
                    stepRunData.put("stepRun_" + stepRun.getStep().getName(), stepRunOutputs.get(stepRun.getRunId()));
                }
                args.add(Py.newStringOrUnicode((String)JSON.json((Object)stepRunData)));
            }
            if (!((variablesObj = entryPoint.__call__(args.toArray(new PyObject[0]))) instanceof PyDictionary)) {
                throw new IllegalArgumentException("The function " + PYTHON_FUNCTION_NAME + " must return a map of variables");
            }
            PyDictionary variablesDict = (PyDictionary)variablesObj;
            for (StepRun varName : variablesDict.keySet()) {
                String varNameStr = (String)((Object)varName);
                lookup.addVariable(varNameStr, variablesDict.get((Object)varName));
            }
        }
        catch (PyException e) {
            throw ErrorContext.iae((String)(String.valueOf(e.type) + " : " + String.valueOf(e.value)));
        }
    }

    public static interface ReporterRunnerBuilder {
        public ScenarioReporterRunner build(ScenarioReporter var1, ScenarioRun var2, Scenario var3);
    }
}

