/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;

public class FlowComputableSpecification {
    public FlowComputable.FCType type;
    public String projectKey;
    public String itemId;
    public String partitionsSpec;

    public static FlowComputableSpecification make(String projectKey, TaggableObjectsService.TaggableObjectRef ref) {
        FlowComputableSpecification ret = new FlowComputableSpecification();
        ret.itemId = ref.id;
        if (!StringUtils.equals((String)projectKey, (String)ref.projectKey)) {
            ret.projectKey = ref.projectKey;
        }
        ret.type = FlowComputable.FCType.fromTaggableType(ref.type);
        return ret;
    }

    public FlowComputableSpecification withProjectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    public FlowComputableSpecification withType(FlowComputable.FCType type) {
        this.type = type;
        return this;
    }

    public FlowComputableSpecification withType(ITaggingService.TaggableType type) {
        return this.withType(FlowComputable.FCType.fromTaggableType(type));
    }

    public FlowComputableSpecification withItemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    public FlowComputableSpecification withPartitionSpec(String partitionsSpec) {
        this.partitionsSpec = partitionsSpec;
        return this;
    }

    public JobDef.JobOutput buildOutput(String scenarioProjectKey) {
        return new JobDef.JobOutput(this.projectKey == null ? scenarioProjectKey : this.projectKey, this.itemId, this.partitionsSpec);
    }

    public JobDef.ReverseJobStartingPoint buildReverseStartingPoint(String scenarioProjectKey) {
        JobDef.ReverseJobStartingPoint r = new JobDef.ReverseJobStartingPoint();
        r.projectKey = this.projectKey == null ? scenarioProjectKey : this.projectKey;
        r.graphNodeSupertype = JobDef.GraphNodeSupertype.COMPUTABLE;
        r.id = this.itemId;
        return r;
    }

    public Object getObjectOrNull(String projectKey, DatasetsDAO datasetsDAO, ManagedFolderDAO managedFolderDAO, SavedModelsDAO savedModelsDAO, ModelEvaluationStoresDAO modelEvaluationStoresDAO, RetrievableKnowledgeDAO retrievableKnowledgeDAO) throws Exception {
        projectKey = StringUtils.isBlank((String)this.projectKey) ? projectKey : this.projectKey;
        switch (this.type) {
            case DATASET: {
                SerializedDataset sd = (SerializedDataset)datasetsDAO.getOrNull(projectKey, this.itemId);
                if (sd == null) {
                    throw new Exception("Dataset " + this.itemId + " doesn't exist");
                }
                return Dataset.fromSerialized(sd);
            }
            case MANAGED_FOLDER: {
                return managedFolderDAO.getOrNull(projectKey, this.itemId);
            }
            case SAVED_MODEL: {
                return savedModelsDAO.getOrNull(projectKey, this.itemId);
            }
            case MODEL_EVALUATION_STORE: {
                return modelEvaluationStoresDAO.getOrNull(projectKey, this.itemId);
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return retrievableKnowledgeDAO.getOrNull(projectKey, this.itemId);
            }
        }
        throw new Exception("Unknown type " + String.valueOf((Object)this.type));
    }

    public AnyLoc getLoc(String projectKey) {
        projectKey = StringUtils.isBlank((String)this.projectKey) ? projectKey : this.projectKey;
        return new AnyLoc(projectKey, this.itemId);
    }

    public ReportTargetItem getTargetItem(String projectKey, String partitionId) throws Exception {
        projectKey = StringUtils.isBlank((String)this.projectKey) ? projectKey : this.projectKey;
        switch (this.type) {
            case DATASET: {
                if (StringUtils.isBlank((String)partitionId)) {
                    return new ReportTargetItem.DatasetItem(projectKey, this.itemId);
                }
                return new ReportTargetItem.DatasetPartitionItem(projectKey, this.itemId, partitionId);
            }
            case MANAGED_FOLDER: {
                if (StringUtils.isBlank((String)partitionId)) {
                    return new ReportTargetItem.ManagedFolderItem(projectKey, this.itemId);
                }
                return new ReportTargetItem.ManagedFolderPartitionItem(projectKey, this.itemId, partitionId);
            }
            case SAVED_MODEL: {
                if (StringUtils.isBlank((String)partitionId)) {
                    return new ReportTargetItem.SavedModelItem(projectKey, this.itemId);
                }
                return new ReportTargetItem.SavedModelPartitionItem(projectKey, this.itemId, partitionId);
            }
            case MODEL_EVALUATION_STORE: {
                if (StringUtils.isBlank((String)partitionId)) {
                    return new ReportTargetItem.ModelEvaluationStoreItem(projectKey, this.itemId);
                }
                return new ReportTargetItem.ModelEvaluationStorePartitionItem(projectKey, this.itemId, partitionId);
            }
        }
        throw new Exception("Unknown type " + String.valueOf((Object)this.type));
    }

    public String getItemName() {
        if (this.type == FlowComputable.FCType.DATASET) {
            return "dataset " + this.itemId;
        }
        if (this.type == FlowComputable.FCType.MANAGED_FOLDER) {
            return "folder " + this.itemId;
        }
        if (this.type == FlowComputable.FCType.SAVED_MODEL) {
            return "model " + this.itemId;
        }
        if (this.type == FlowComputable.FCType.MODEL_EVALUATION_STORE) {
            return "evaluation store " + this.itemId;
        }
        return this.itemId;
    }

    public String getPartitionInvariantId() {
        String fullName = (String)(StringUtils.isNotBlank((String)this.projectKey) ? this.projectKey + "." : "") + this.itemId;
        if (this.type == FlowComputable.FCType.DATASET) {
            return "d_" + fullName;
        }
        if (this.type == FlowComputable.FCType.MANAGED_FOLDER) {
            return "f_" + fullName;
        }
        if (this.type == FlowComputable.FCType.SAVED_MODEL) {
            return "m_" + fullName;
        }
        if (this.type == FlowComputable.FCType.MODEL_EVALUATION_STORE) {
            return "e_" + fullName;
        }
        return "u_" + fullName;
    }

    public Object resolveTarget(String scenarioProjectKey, DatasetsDAO datasetsDAO, ManagedFolderDAO managedFolderDAO, SavedModelsDAO savedModelsDAO, ModelEvaluationStoresDAO modelEvaluationStoresDAO, RetrievableKnowledgeDAO retrievableKnowledgeDAO) throws Exception {
        Object object = this.getObjectOrNull(scenarioProjectKey, datasetsDAO, managedFolderDAO, savedModelsDAO, modelEvaluationStoresDAO, retrievableKnowledgeDAO);
        if (object == null) {
            throw new Exception("Target " + this.getItemName() + " of step not found in project " + scenarioProjectKey);
        }
        return object;
    }

    public List<Partition> resolvePartitions_NT(Object object, StrSubstitutor substitutor, @Nullable PredictionSMMgmtService predictionSMMgmtService, @Nullable ClusteringSMMgmtService clusteringSMMgmtService, ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        ArrayList<Partition> toCompute = new ArrayList<Partition>();
        if (object instanceof Partitionable && this.type != FlowComputable.FCType.SAVED_MODEL && this.type != FlowComputable.FCType.MODEL_EVALUATION_STORE) {
            Partitionable partitioned;
            PartitioningScheme partitioningScheme;
            String computedPartitionSpec = this.partitionsSpec;
            if (!StringUtils.isBlank((String)computedPartitionSpec)) {
                computedPartitionSpec = substitutor.replace(computedPartitionSpec);
            }
            if (!(partitioningScheme = (partitioned = (Partitionable)object).getPartitioningSchema()).isPartitioned()) {
                if (computedPartitionSpec != null && computedPartitionSpec.length() > 0) {
                    throw ErrorContext.iaef((String)"Dataset '%s.%s' is not partitioned, unexpected partition identifier", (Object)this.projectKey, (Object[])new Object[]{this.itemId});
                }
                toCompute.add(PartitionFactory.fromIdentifier(partitioningScheme, "NP"));
            } else if (computedPartitionSpec != null && computedPartitionSpec.length() > 0) {
                toCompute.addAll(PartitionFactory.fromPartitionSpec(partitioningScheme, computedPartitionSpec));
            } else {
                toCompute.add(Partition.newALL((PartitioningScheme)partitioningScheme));
            }
        } else if (this.type == FlowComputable.FCType.SAVED_MODEL && predictionSMMgmtService != null && clusteringSMMgmtService != null) {
            String computedPartitionSpec = this.partitionsSpec;
            if (!StringUtils.isBlank((String)computedPartitionSpec)) {
                computedPartitionSpec = substitutor.replace(computedPartitionSpec);
            }
            if (StringUtils.isBlank((String)computedPartitionSpec)) {
                computedPartitionSpec = "LATEST";
            }
            SavedModel savedModel = (SavedModel)object;
            String versionId = null;
            if (computedPartitionSpec.equalsIgnoreCase("latest")) {
                if (savedModel.getType() == MLTask.MLTaskType.PREDICTION) {
                    List versions = predictionSMMgmtService.getStatus_NT((SavedModel)savedModel).versions;
                    if (versions.size() == 0) {
                        throw new IllegalArgumentException("Model " + savedModel.id + " in project " + savedModel.projectKey + " has 0 version");
                    }
                    Collections.sort(versions, new Comparator<PredictionSMMgmtService.PredictionSMVersionHeader>(){

                        @Override
                        public int compare(PredictionSMMgmtService.PredictionSMVersionHeader arg0, PredictionSMMgmtService.PredictionSMVersionHeader arg1) {
                            long v0 = 0L;
                            long v1 = 0L;
                            try {
                                v0 = Long.parseLong(arg0.versionId);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                v1 = Long.parseLong(arg1.versionId);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return -Long.compare(v0, v1);
                        }
                    });
                    versionId = ((PredictionSMMgmtService.PredictionSMVersionHeader)versions.get((int)0)).versionId;
                } else {
                    List versions = clusteringSMMgmtService.getStatus_NT((SavedModel)savedModel).versions;
                    if (versions.size() == 0) {
                        throw new IllegalArgumentException("Model " + savedModel.id + " in project " + savedModel.projectKey + " has 0 version");
                    }
                    Collections.sort(versions, new Comparator<ClusteringSMMgmtService.ClusteringSMVersionHeader>(){

                        @Override
                        public int compare(ClusteringSMMgmtService.ClusteringSMVersionHeader arg0, ClusteringSMMgmtService.ClusteringSMVersionHeader arg1) {
                            long v0 = 0L;
                            long v1 = 0L;
                            try {
                                v0 = Long.parseLong(arg0.versionId);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                v1 = Long.parseLong(arg1.versionId);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return -Long.compare(v0, v1);
                        }
                    });
                    versionId = ((ClusteringSMMgmtService.ClusteringSMVersionHeader)versions.get((int)0)).versionId;
                }
            } else {
                versionId = computedPartitionSpec.equalsIgnoreCase("active") ? savedModel.activeVersion : computedPartitionSpec;
            }
            toCompute.add(MetricsComputationService.fakeSMVersionPartition(versionId));
        } else if (this.type == FlowComputable.FCType.MODEL_EVALUATION_STORE) {
            ModelEvaluationStore mes = (ModelEvaluationStore)object;
            String latestEvaluationId = modelEvaluationStoresCRUDService.getLatestEvaluationId(mes.projectKey, mes.id);
            toCompute.add(MetricsComputationService.fakeSMVersionPartition(latestEvaluationId));
        } else {
            toCompute.add(null);
        }
        return toCompute;
    }
}

