/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.ProjectLibrariesEditionService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.plugins.dev.FolderEditorService;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.MimeTypesSecurity;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.NotLoggedInException;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.admin.AdminEditionController;
import com.dataiku.dip.server.services.GitReferencesService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.git.DSSTransactionProviderSettings;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ProjectContentsEditionController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private FolderEditorService folderEditorService;
    @Autowired
    private ProjectLibrariesEditionService projectLibrariesEditionService;
    @Autowired
    private GitReferencesService gitReferencesService;
    @Autowired
    private IPermissionsService permissionsService;
    private TransactionProvider libProjectsTransactionProvider;
    private static final Logger logger = Logger.getLogger((String)"dku.project.editfolder");

    @PostConstruct
    public void setupGit() throws IOException {
        logger.debug((Object)"Init projectedit service");
        File libProjects = ApplicationConfigurator.getFile((String[])new String[]{"lib", "projects"});
        DKUFileUtils.mkdirs((File)libProjects);
        this.libProjectsTransactionProvider = new TransactionProvider(libProjects, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, false, true));
        logger.debug((Object)"Done init projectedit service");
    }

    private AuthCtx getAndCheckUser(HttpServletRequest req, String projectKey, Privileges.ProjectLevelPrivilegeType permissionLevel) throws IOException, DKUSecurityException {
        AuthCtx user = this.authService.getMandatoryUser(req);
        this.projectsService.checkPerm(user, projectKey, permissionLevel);
        if (permissionLevel != Privileges.ProjectLevelPrivilegeType.READ_CONF && permissionLevel != Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS) {
            user.failIfNoSafeCode("edit the contents of the project's libraries");
        }
        return user;
    }

    private AuthCtx getAndCheckUser(HttpServletRequest req, String projectKey) throws IOException, DKUSecurityException {
        return this.getAndCheckUser(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
    }

    private AuthCtx getAndCheckUserNoXSRF(HttpServletRequest req, String projectKey) throws IOException, DKUSecurityException {
        AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
        this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        user.failIfNoSafeCode("edit the contents of the project's libraries");
        return user;
    }

    @AuditedCall(value={"msgType", "project-folder-edit-list", "projectKey", "${projectKey}", "folderType", "${type}"})
    @RequestMapping(value={"/api/projects/folder-edition/list-contents"})
    @ResponseBody
    public List<FolderEditorService.FolderContent> listContents(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type) throws Exception {
        List<FolderEditorService.FolderContent> ret;
        AuthCtx authCtx = null;
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ret = this.folderEditorService.getFolderContent(zone.getPath(projectKey), (TransactionRef)t);
        }
        return this.projectLibrariesEditionService.autocompleteProjectLibrariesContent_NT(authCtx, projectKey, ret);
    }

    @AuditedCall(value={"msgType", "project-folder-edit-get", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/folder-edition/get-content"})
    @ResponseBody
    public FolderEditorService.FolderContent getContent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam boolean sendAnyway) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.getAndCheckUser(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            FolderEditorService.FolderContent folderContent = this.folderEditorService.getFolderContent(zone.getPath(projectKey), path, sendAnyway, null, t);
            return folderContent;
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-preview-image", "projectKey", "${projectKey}", "path", "${path}", "contentType", "${contentType}"})
    @RequestMapping(value={"/api/projects/folder-edition/preview-image"}, method={RequestMethod.GET})
    public void previewImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam String contentType) throws Exception {
        byte[] picData;
        MimeTypesSecurity.failIfNotSafeImageType((String)contentType);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            picData = this.folderEditorService.previewImageStream(zone.getPath(projectKey), path, t);
        }
        resp.setContentType(contentType);
        resp.getOutputStream().write(picData);
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/folder-edition/set-content"})
    public void setContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam String data) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.getAndCheckUser(req, projectKey);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            if (this.folderEditorService.setFolderContent(zone.getPath(projectKey), path, data, (RWTransactionRef)t, true)) {
                t.commit(ProjectContentsEditionController.getCommitMessage("Edited", zone, path));
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}"})
    @RequestMapping(value={"/api/projects/folder-edition/set-content-multiple"})
    public void setContentMultiple(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String contentMap) throws Exception {
        Map fileMap = (Map)JSON.parse((String)contentMap, (TypeToken)new TypeToken<Map<String, String>>(){});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.getAndCheckUser(req, projectKey);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            if (this.folderEditorService.setFolderContentList(zone.getPath(projectKey), fileMap, t, true)) {
                t.commit(ProjectContentsEditionController.getCommitMessage("Edited", zone, fileMap.keySet()));
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-create", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/folder-edition/create-content"})
    public void createContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam boolean isFolder) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.getAndCheckUser(req, projectKey);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            this.folderEditorService.addFolderContent(zone.getPath(projectKey), path, isFolder, (RWTransactionRef)t);
            t.commit(ProjectContentsEditionController.getCommitMessage("Created", zone, path, isFolder));
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-delete", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/folder-edition/delete-content"})
    public void deleteContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.getAndCheckUser(req, projectKey);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            FolderEditorService.FileType fileType = this.folderEditorService.removeFolderContent(zone.getPath(projectKey), path, t);
            if (zone == AdminEditionController.GlobalCodeZone.LIB) {
                this.gitReferencesService.removeGitReferencesAfterPathDeletion(projectKey, path);
            }
            boolean isFolder = fileType == FolderEditorService.FileType.FOLDER;
            t.commit(ProjectContentsEditionController.getCommitMessage("Deleted", zone, path, isFolder));
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/folder-edition/decompress-content"})
    public void decompressContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.getAndCheckUser(req, projectKey);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            this.folderEditorService.decompressFolderContent(zone.getPath(projectKey), path, t);
            t.commit(ProjectContentsEditionController.getCommitMessage("Decompressed", zone, path));
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/folder-edition/rename-content"})
    @ResponseBody
    public FolderEditorService.FolderContent renameContent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam String newName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.getAndCheckUser(req, projectKey);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            FolderEditorService.FolderContent newContent = this.folderEditorService.renameFolderContent(zone.getPath(projectKey), path, newName, t);
            if (zone == AdminEditionController.GlobalCodeZone.LIB) {
                this.gitReferencesService.updateGitReferencesAfterPathUpdate(projectKey, path, newContent.path);
            }
            boolean isFolder = newContent.mimeType == null;
            t.commit(ProjectContentsEditionController.getCommitMessage("Renamed", zone, path, isFolder) + " to \"" + newName + "\"");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/folder-edition/move-content"})
    @ResponseBody
    public FolderEditorService.FolderContent moveContent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam String toPath) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.getAndCheckUser(req, projectKey);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            FolderEditorService.FolderContent newContent = this.folderEditorService.moveFolderContent(zone.getPath(projectKey), path, toPath, t);
            if (zone == AdminEditionController.GlobalCodeZone.LIB) {
                this.gitReferencesService.updateGitReferencesAfterPathUpdate(projectKey, path, newContent.path);
            }
            boolean isFolder = newContent.mimeType == null;
            t.commit(ProjectContentsEditionController.getCommitMessage("Moved", zone, path, isFolder) + " to \"" + toPath + "\"");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/folder-edition/copy-content"})
    @ResponseBody
    public Object copyContent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.getAndCheckUser(req, projectKey);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            FolderEditorService.FolderContent newContent = this.folderEditorService.copyFolderContent(zone.getPath(projectKey), path, t);
            boolean isFolder = newContent.mimeType == null;
            t.commit(ProjectContentsEditionController.getCommitMessage("Copied", zone, path, isFolder));
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/projects/folder-edition/check-upload-content"})
    @ResponseBody
    public FolderEditorService.UploadFeasabilities checkUploadContent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam(value="filePaths") String filePathsData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.getAndCheckUser(req, projectKey);
            List filePaths = (List)JSON.parse((String)filePathsData, (TypeToken)new TypeToken<List<String>>(){});
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            FolderEditorService.UploadFeasabilities uploadFeasabilities = this.folderEditorService.checkUploadContent(zone.getPath(projectKey), path, filePaths, t);
            return uploadFeasabilities;
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-upload", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/folder-edition/upload-content"})
    @ResponseBody
    public FolderEditorService.FolderContent uploadContent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req, false);){
            this.getAndCheckUser(req, projectKey);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            String filename = filePart.getOriginalFilename();
            Callable<FolderEditorService.FolderContent> callableUploadHandler = this.folderEditorService.uploadContent(zone.getPath(projectKey), path, filePart.getInputStream(), filename, t);
            FolderEditorService.FolderContent newContent = callableUploadHandler.call();
            t.commit(ProjectContentsEditionController.getCommitMessage("Uploaded", zone, path + "/" + filename));
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-download", "projectKey", "${projectKey}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/folder-edition/download-content"}, method={RequestMethod.GET})
    public void downloadContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
            this.folderEditorService.streamContent(zone.getPath(projectKey), path, resp, t);
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-list", "projectKey", "${projectKey}", "folderType", "${type}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/list-contents"})
    @ResponseBody
    public List<FolderEditorService.FolderContent> listContentsResources(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type) throws Exception {
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginRead();
        try {
            List<FolderEditorService.FolderContent> list = this.folderEditorService.getFolderContent(zone.getProjectSubPath(projectKey), (TransactionRef)t);
            return list;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-get", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/get-content"})
    @ResponseBody
    public FolderEditorService.FolderContent getContentResources(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam boolean sendAnyway) throws Exception {
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginRead();
        try {
            FolderEditorService.FolderContent folderContent = this.folderEditorService.getFolderContent(zone.getProjectSubPath(projectKey), path, sendAnyway, null, t);
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-preview-image", "projectKey", "${projectKey}", "path", "${path}", "contentType", "${contentType}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/preview-image"}, method={RequestMethod.GET})
    public void previewImageResources(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam String contentType) throws Exception {
        byte[] picData;
        MimeTypesSecurity.failIfNotSafeImageType((String)contentType);
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            this.getAndCheckUserNoXSRF(req, projectKey);
        }
        try (Transaction t = this.libProjectsTransactionProvider.beginRead();){
            picData = this.folderEditorService.previewImageStream(zone.getProjectSubPath(projectKey), path, t);
        }
        resp.setContentType(contentType);
        resp.getOutputStream().write(picData);
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/set-content"})
    public void setContentResources(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam String data) throws Exception {
        AuthCtx authCtx;
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginWrite(authCtx);
        try {
            if (this.folderEditorService.setFolderContent(zone.getProjectSubPath(projectKey), path, data, (RWTransactionRef)t, true)) {
                t.commit(ProjectContentsEditionController.getCommitMessage("Edited", zone, path));
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/set-content-multiple"})
    public void setContentMultipleResources(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String contentMap) throws Exception {
        AuthCtx authCtx;
        Map fileMap = (Map)JSON.parse((String)contentMap, (TypeToken)new TypeToken<Map<String, String>>(){});
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginWrite(authCtx);
        try {
            if (this.folderEditorService.setFolderContentList(zone.getProjectSubPath(projectKey), fileMap, (RWTransaction)t, true)) {
                t.commit(ProjectContentsEditionController.getCommitMessage("Edited", zone, fileMap.keySet()));
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-create", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/create-content"})
    public void createContentResources(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam boolean isFolder) throws Exception {
        AuthCtx authCtx;
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginWrite(authCtx);
        try {
            this.folderEditorService.addFolderContent(zone.getProjectSubPath(projectKey), path, isFolder, (RWTransactionRef)t);
            t.commit(ProjectContentsEditionController.getCommitMessage("Created", zone, path, isFolder));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-delete", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/delete-content"})
    public void deleteContentResources(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path) throws Exception {
        AuthCtx authCtx;
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginWrite(authCtx);
        try {
            FolderEditorService.FileType fileType = this.folderEditorService.removeFolderContent(zone.getProjectSubPath(projectKey), path, (RWTransaction)t);
            boolean isFolder = fileType == FolderEditorService.FileType.FOLDER;
            t.commit(ProjectContentsEditionController.getCommitMessage("Deleted", zone, path, isFolder));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/decompress-content"})
    public void decompressContentResources(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path) throws Exception {
        AuthCtx authCtx;
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginWrite(authCtx);
        try {
            this.folderEditorService.decompressFolderContent(zone.getProjectSubPath(projectKey), path, (RWTransaction)t);
            t.commit(ProjectContentsEditionController.getCommitMessage("Decompressed", zone, path));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/rename-content"})
    @ResponseBody
    public FolderEditorService.FolderContent renameContentResources(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam String newName) throws Exception {
        AuthCtx authCtx;
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginWrite(authCtx);
        try {
            FolderEditorService.FolderContent newContent = this.folderEditorService.renameFolderContent(zone.getProjectSubPath(projectKey), path, newName, (RWTransaction)t);
            boolean isFolder = newContent.mimeType == null;
            t.commit(ProjectContentsEditionController.getCommitMessage("Renamed", zone, path, isFolder) + " to \"" + newName + "\"");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/move-content"})
    @ResponseBody
    public FolderEditorService.FolderContent moveContentResources(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam String toPath) throws Exception {
        AuthCtx authCtx;
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginWrite(authCtx);
        try {
            FolderEditorService.FolderContent newContent = this.folderEditorService.moveFolderContent(zone.getProjectSubPath(projectKey), path, toPath, (RWTransaction)t);
            boolean isFolder = newContent.mimeType == null;
            t.commit(ProjectContentsEditionController.getCommitMessage("Moved", zone, path, isFolder) + " to \"" + toPath + "\"");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-save", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/copy-content"})
    @ResponseBody
    public FolderEditorService.FolderContent copyContentResources(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path) throws Exception {
        AuthCtx authCtx;
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginWrite(authCtx);
        try {
            FolderEditorService.FolderContent newContent = this.folderEditorService.copyFolderContent(zone.getProjectSubPath(projectKey), path, (RWTransaction)t);
            boolean isFolder = newContent.mimeType == null;
            t.commit(ProjectContentsEditionController.getCommitMessage("Copied", zone, path, isFolder));
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/projects/resources-folder-edition/check-upload-content"})
    @ResponseBody
    public FolderEditorService.UploadFeasabilities checkUploadContentResources(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam List<String> filePaths) throws Exception {
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginRead();
        try {
            FolderEditorService.UploadFeasabilities uploadFeasabilities = this.folderEditorService.checkUploadContent(zone.getProjectSubPath(projectKey), path, filePaths, t);
            return uploadFeasabilities;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-upload", "projectKey", "${projectKey}", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/upload-content"})
    @ResponseBody
    public FolderEditorService.FolderContent uploadContentResources(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        AuthCtx authCtx;
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginWrite(authCtx);
        try {
            Callable<FolderEditorService.FolderContent> callableUploadHandler = this.folderEditorService.uploadContent(zone.getProjectSubPath(projectKey), path, filePart.getInputStream(), filePart.getOriginalFilename(), (RWTransaction)t);
            FolderEditorService.FolderContent newContent = callableUploadHandler.call();
            t.commit("upload file");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-folder-edit-download", "projectKey", "${projectKey}", "path", "${path}"})
    @RequestMapping(value={"/api/projects/resources-folder-edition/download-content"}, method={RequestMethod.GET})
    public void downloadContentResources(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String path) throws Exception {
        AuthCtx authCtx;
        AdminEditionController.GlobalCodeZone zone = AdminEditionController.GlobalCodeZone.valueOf(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUserNoXSRF(req, projectKey);
        }
        t = this.libProjectsTransactionProvider.beginWrite(authCtx);
        try {
            this.folderEditorService.streamContent(zone.getProjectSubPath(projectKey), path, resp, t);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "project-protected-lib"})
    @RequestMapping(value={"/api/projects/{projectKey}/check-access"})
    public void checkAccess(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            resp.setHeader("X-DKU-studioUrl", RemoteRunNetworkingUtils.getStudioExternalURL());
            authCtx = this.authService.getUserNoXSRF(req);
            if (authCtx == null) {
                resp.setHeader("X-DKU-accessForbiddenReason", "The project static resources cannot be accessed without being logged into <a href=\"" + RemoteRunNetworkingUtils.getStudioExternalURL() + "\">DSS</a>.");
                throw new NotLoggedInException("Not logged in DSS");
            }
            if (!this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                resp.setHeader("X-DKU-accessForbiddenReason", "The project static resources cannot be accessed with the current credentials. Use a different login <a href=\"" + RemoteRunNetworkingUtils.getStudioExternalURL() + "\">DSS</a>");
                throw new UnauthorizedException("Access to project rejected", "project-access-failed");
            }
        }
        logger.info((Object)("Accept for " + String.valueOf(authCtx) + " on " + projectKey));
        resp.setStatus(200);
    }

    private static String getCommitMessage(String verb, AdminEditionController.GlobalCodeZone zone, String path) {
        return ProjectContentsEditionController.getCommitMessage(verb, zone, Collections.singleton(path), false);
    }

    private static String getCommitMessage(String verb, AdminEditionController.GlobalCodeZone zone, String path, boolean isFolder) {
        return ProjectContentsEditionController.getCommitMessage(verb, zone, Collections.singleton(path), isFolder);
    }

    private static String getCommitMessage(String verb, AdminEditionController.GlobalCodeZone zone, Collection<String> itemPaths) {
        return ProjectContentsEditionController.getCommitMessage(verb, zone, itemPaths, false);
    }

    private static String getCommitMessage(String verb, AdminEditionController.GlobalCodeZone zone, Collection<String> itemPaths, boolean isFolder) {
        StringBuilder out = new StringBuilder(verb);
        int itemCount = itemPaths.size();
        if (itemCount > 1) {
            out.append(" multiple");
        }
        out.append(" ").append(AdminEditionController.GlobalCodeZone.LOCAL_STATIC == zone ? "Local" : "Library");
        if (itemCount > 1) {
            out.append(" ").append(isFolder ? "folders" : "files");
        } else if (itemCount == 1) {
            out.append(" ").append(isFolder ? "folder" : "file");
            out.append(" \"");
            out.append(itemPaths.iterator().next());
            out.append("\"");
        }
        return out.toString();
    }
}

