/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.externalinfras;

import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.externalinfras.ExternalInfraEndpoint;
import com.dataiku.dip.externalinfras.ExternalInfraRegionDTO;
import com.dataiku.dip.externalinfras.ExternalInfrasService;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksExperiment;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModel;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModelVersion;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointDetails;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.externalinfras.vertexai.datamodel.GCPProject;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ExternalInfrasController
extends DIPInternalControllerBase {
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    UIAuthService authService;
    @Autowired
    protected ExternalInfrasService externalInfrasService;
    @Autowired
    ConnectionsService connectionsService;

    @AuditedCall(value={"msgType", "externalinfras-list-sagemaker-endpoints", "region", "${region}", "connection", "${connection}"})
    @RequestMapping(value={"/api/external-infras/list-sagemaker-endpoints"})
    @ResponseBody
    public FutureResponse<List<ExternalInfraEndpoint>> listSageMakerEndpoints(HttpServletRequest req, @RequestParam(required=false) String project, @RequestParam String region, @RequestParam(required=false) String connection) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.externalInfrasService.listSageMakerEndpointSummaries(authCtx, project, region, connection);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/external-infras/list-sagemaker-regions"})
    @ResponseBody
    public List<ExternalInfraRegionDTO> listSageMakerRegions() {
        return SageMakerUtils.getSageMakerRegions_NT();
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/external-infras/list-vertexai-regions"})
    @ResponseBody
    public List<ExternalInfraRegionDTO> listVertexAIRegions() {
        return VertexAIUtils.getVertexAIRegions_NT();
    }

    @AuditedCall(value={"msgType", "externalinfras-list-azureml-endpoints", "project", "${project}", "workspace", "${workspace}", "resourceGroup", "${resourceGroup}", "subscription", "${subscription}", "connection", "${connection}"})
    @RequestMapping(value={"/api/external-infras/list-azureml-endpoints"})
    @ResponseBody
    public FutureResponse<List<ExternalInfraEndpoint>> listAzureMLEndpoints(HttpServletRequest req, @RequestParam(required=false) String project, @RequestParam String workspace, @RequestParam String resourceGroup, @RequestParam String subscription, @RequestParam(required=false) String connection) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.externalInfrasService.listAzureMLEndpoints(authCtx, connection, project, workspace, resourceGroup, subscription);
    }

    @AuditedCall(value={"msgType", "externalinfras-list-vertexai-projects", "connection", "${connection}"})
    @RequestMapping(value={"/api/external-infras/list-vertexai-projects"})
    @ResponseBody
    public FutureResponse<List<GCPProject>> listVertexAIProjects(HttpServletRequest req, @RequestParam(required=false) String connection) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.externalInfrasService.listVertexAIProjects(authCtx, connection);
    }

    @AuditedCall(value={"msgType", "externalinfras-get-vertexai-project", "projectId", "${projectId}", "connection", "${connection}"})
    @RequestMapping(value={"/api/external-infras/get-vertexai-project"}, method={RequestMethod.GET})
    @ResponseBody
    public FutureResponse<GCPProject> getVertexAIProject(HttpServletRequest req, @RequestParam String projectId, @RequestParam(required=false) String connection) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.externalInfrasService.getVertexAIProject(authCtx, projectId, connection);
    }

    @AuditedCall(value={"msgType", "externalinfras-list-vertexai-endpoints", "project", "${project}", "region", "${region}", "connection", "${connection}"})
    @RequestMapping(value={"/api/external-infras/list-vertexai-endpoints"})
    @ResponseBody
    public FutureResponse<List<ExternalInfraEndpoint>> listVertexAIEndpoints(HttpServletRequest req, @RequestParam String project, @RequestParam String region, @RequestParam(required=false) String connection) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.externalInfrasService.listVertexAIEndpoints(authCtx, project, region, connection);
    }

    @AuditedCall(value={"msgType", "externalinfras-list-databricks-registered-models", "connectionName", "${connectionName}", "useUnityCatalog", "${useUnityCatalog}"})
    @RequestMapping(value={"/api/external-infras/list-databricks-registered-models"})
    @ResponseBody
    public FutureResponse<List<DatabricksRegisteredModel>> listDatabricksRegisteredModels(HttpServletRequest req, @RequestParam String connectionName, @RequestParam(defaultValue="false") boolean useUnityCatalog) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.externalInfrasService.listDatabricksRegisteredModels(authCtx, connectionName, useUnityCatalog);
    }

    @AuditedCall(value={"msgType", "externalinfras-list-databricks-model-versions", "connectionName", "${connectionName}", "modelName", "${modelName}", "useUnityCatalog", "${useUnityCatalog}"})
    @RequestMapping(value={"/api/external-infras/list-databricks-model-versions"})
    @ResponseBody
    public FutureResponse<List<DatabricksRegisteredModelVersion>> listDatabricksRegisteredModelVersions(HttpServletRequest req, @RequestParam String connectionName, @RequestParam String modelName, @RequestParam(defaultValue="false") boolean useUnityCatalog) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.externalInfrasService.listDatabricksRegisteredModelVersions(authCtx, connectionName, modelName, useUnityCatalog);
    }

    @AuditedCall(value={"msgType", "externalinfras-list-databricks-endpoints", "project", "${project}", "connection", "${connectionName}"})
    @RequestMapping(value={"/api/external-infras/list-databricks-endpoints"})
    @ResponseBody
    public FutureResponse<List<ExternalInfraEndpoint>> listDatabricksEndpoints(HttpServletRequest req, @RequestParam(required=false) String project, @RequestParam String connectionName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.externalInfrasService.listDatabricksEndpoints(authCtx, connectionName);
    }

    @AuditedCall(value={"msgType", "externalinfras-list-databricks-experiments", "connection", "${connectionName}"})
    @RequestMapping(value={"/api/external-infras/list-databricks-experiments"})
    @ResponseBody
    public FutureResponse<List<DatabricksExperiment>> listDatabricksExperiments(HttpServletRequest req, @RequestParam String connectionName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.externalInfrasService.listDatabricksExperiments(authCtx, connectionName);
    }

    @AuditedCall(value={"msgType", "externalinfras-list-databricks-endpoints", "connection", "${connectionName}"})
    @RequestMapping(value={"/api/external-infras/get-databricks-endpoint"})
    @ResponseBody
    public DatabricksServingEndpointDetails getDatabricksEndpoint(HttpServletRequest req, @RequestParam String connectionName, @RequestParam String endpointName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return DatabricksUtils.getEndpoint(authCtx, connectionName, endpointName, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
    }

    @AuditedCall(value={"msgType", "externalinfras-list-snowpark-endpoints", "database", "${database}", "schema", "${schema}", "connection", "${connectionName}"})
    @RequestMapping(value={"/api/external-infras/list-snowpark-endpoints"})
    @ResponseBody
    public FutureResponse<List<ExternalInfraEndpoint>> listSnowparkEndpoints(HttpServletRequest req, @RequestParam String database, @RequestParam String schema, @RequestParam String connectionName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.externalInfrasService.listSnowparkEndpoints(authCtx, connectionName, database, schema);
    }
}

