/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.server.services.AchievementsService;

public class AchievementEvent
extends BackendEvent
implements UserEvent,
EventWithHumanReadableString {
    public static final String NAME = "achievement-unlocked";
    private final String user;
    private final String achievementId;

    public AchievementEvent(String user, AchievementsService.AchievementId id) {
        this.user = user;
        this.achievementId = id.toString();
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        return String.format("User %s unlocked achievement %s", markup.user(this.user, null), markup.text(this.achievementId));
    }
}

