/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.comparator.LastModifiedFileComparator;
import com.dataiku.dss.shadelib.org.apache.commons.io.filefilter.WildcardFileFilter;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiagnosticsService {
    @Autowired
    FutureService futureService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.diagnostics");

    public String run(String serializedOptions, AuthCtx user) throws Exception {
        DiagnosticsOptions opts = null;
        if (StringUtils.isNotBlank((String)serializedOptions)) {
            opts = (DiagnosticsOptions)JSON.parse((String)serializedOptions, DiagnosticsOptions.class);
        }
        return this.futureService.runFuture((DiagnosticsService)this.new DiagnosticsFutureThread((DiagnosticsOptions)opts, (DSSAuthCtx)((DSSAuthCtx)user)), (long)0L, new TypeToken<FutureResponse<DiagnosticResult>>(){}).jobId;
    }

    public File getLatestDiagnosisFile() throws IOException {
        WildcardFileFilter filter = new WildcardFileFilter("dku_diagnosis*.zip");
        File[] logFiles = ApplicationConfigurator.getFile((String)"diagnosis").listFiles((FileFilter)filter);
        if (logFiles != null && logFiles.length > 0) {
            Arrays.sort(logFiles, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            return logFiles[0];
        }
        return null;
    }

    class DiagnosticsOptions {
        boolean includeConfigDir;
        boolean includeBackendStacks;
        boolean includeDockerImagesListing;
        boolean includeFullLogs;
        boolean includeFullDataDirListing;

        DiagnosticsOptions() {
        }
    }

    class DiagnosticsFutureThread
    extends SimpleFutureThread<DiagnosticResult> {
        private final DiagnosticsOptions opts;
        private DKUtils.SmartLogTailBuilder logTailBuilder;

        public DiagnosticsFutureThread(DiagnosticsOptions opts, DSSAuthCtx authCtx) {
            super((AuthCtx)authCtx);
            this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            this.opts = opts;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"diagnostics", (String)"Running diagnostics");
        }

        @Override
        public DiagnosticResult compute() throws Exception {
            String binary = System.getenv("DIP_HOME") + "/bin/dssadmin";
            ArrayList cmd = Lists.newArrayList((Object[])new String[]{binary});
            cmd.add("run-diagnosis");
            if (this.opts != null) {
                if (this.opts.includeConfigDir) {
                    cmd.add("-c");
                }
                if (this.opts.includeBackendStacks) {
                    cmd.add("-s");
                }
                if (this.opts.includeDockerImagesListing) {
                    cmd.add("-d");
                }
                if (this.opts.includeFullLogs) {
                    cmd.add("-f");
                }
                if (this.opts.includeFullDataDirListing) {
                    cmd.add("-l");
                }
            }
            HashMap<String, String> env = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)System.getenv("DSS_DEV"))) {
                env.put("DEV_MODE", "1");
            }
            cmd.add(System.getenv("DIP_HOME") + "/diagnosis/dku_diagnosis_" + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()) + ".zip");
            logger.info((Object)("Launching diagnostic tool:  " + StringUtils.join((Collection)cmd, (String)" ")));
            DKUtils.execAndLogThrows((String[])cmd.toArray(new String[0]), env, (DKUtils.SmartLogTailBuilder)this.logTailBuilder);
            return new DiagnosticResult();
        }

        public SmartLogTail getLog() {
            return this.logTailBuilder.get();
        }
    }

    static class DiagnosticResult {
        DiagnosticResult() {
        }
    }
}

