/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dao.impl.FlowStateInternalDB;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.jobrunner.JobRuntimeSummary;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobStatus;
import com.dataiku.dip.dataflow.kernel.master.BuildService;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.BackOffStrategy;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.yarn.YarnUtils;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.BackOff;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowExecutionService2 {
    @Autowired
    private BuildService buildService;
    @Autowired
    private ReadWriteJobsInternalDB dbService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private FlowStateInternalDB flowStateInternalDB;
    @Autowired
    private FutureService futureService;
    private static BackOffStrategy BACKOFF_STRATEGY = BackOffStrategy.expBackOff((int)1000, (int)15000, (double)1.015);
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.execution");

    public void abort_NT(AuthCtx u, String projectKey, String jobId) {
        this.dumpStacksIfStillRunning_NT(projectKey, jobId);
        this.buildService.abort_NT(u, projectKey, jobId);
    }

    public String startJobPreview(JobDef jd, AuthCtx user) throws Exception {
        return this.buildService.startJobPreview(jd, (DSSAuthCtx)user);
    }

    public BuildService.PreviewResult getPreviewResult(String projectKey, String jobId) throws IOException {
        return this.buildService.getPreviewResult(projectKey, jobId);
    }

    public void validateRunFully(String projectKey, String jobId, List<String> skippedActivityIds) {
        this.buildService.validateRunFully(projectKey, jobId, skippedActivityIds);
    }

    public String startJob(JobDef jd, AuthCtx user) throws Exception {
        return this.buildService.startJob(jd, (DSSAuthCtx)user);
    }

    public String retry(String projectKey, String oldJobId, AuthCtx u) throws Exception {
        JobSummary summary = this.dbService.getJobSummary(projectKey, oldJobId);
        if (summary == null) {
            throw new IllegalArgumentException("Unknown job " + projectKey + " / " + oldJobId);
        }
        JobDef jobDef = summary.def;
        jobDef.initiationTimestamp = System.currentTimeMillis();
        jobDef.initiator = u.getIdentifier();
        return this.startJob(jobDef, u);
    }

    public List<JobSummary> listLastJobs_NT(String projectKey, int nb) throws Exception {
        List<JobSummary> list = this.dbService.getLastJobs_NT(projectKey, nb);
        for (JobSummary js : list) {
            if (js.stableState || js.def == null) continue;
            try {
                SerializedJobStatus sjs = this.buildService.getStatus(projectKey, js.def.id);
                js.state = sjs.state;
            }
            catch (Exception e) {
                js.state = JobState.ABORTED;
            }
        }
        return list;
    }

    public List<JobSummary> listAllRunningJobs() throws Exception {
        return this.dbService.getRunningJobs(null);
    }

    public List<JobSummary> listRunningJobs(String projectKey) throws Exception {
        return this.dbService.getRunningJobs(projectKey);
    }

    public EnhancedSerializedJobStatus waitUntilFinished_NT(String projectKey, String jobId) throws SQLException, IOException, InterruptedException {
        TransactionContext.assertNoAttachedTransaction();
        BackOff backOff = BACKOFF_STRATEGY.build();
        while (true) {
            JobState state;
            SerializedJobStatus status;
            if ((status = this.buildService.getStatusOrNull(projectKey, jobId)) == null) {
                JobSummary summary = this.dbService.getJobSummary(projectKey, jobId);
                if (summary == null) {
                    throw new IllegalArgumentException("Unknown job " + projectKey + " / " + jobId);
                }
                if (!summary.stableState) {
                    throw new IllegalArgumentException("Job state incoherent " + projectKey + " / " + jobId + " is not stable and not running");
                }
                state = summary.state;
            } else {
                state = status.state;
            }
            if (state != null && state.isFinished()) break;
            long waitMillis = backOff.nextBackOffMillis();
            if (waitMillis < 0L) {
                backOff = BACKOFF_STRATEGY.build();
                waitMillis = backOff.nextBackOffMillis();
            }
            Thread.sleep(waitMillis);
        }
        return this.getStatus_NT(projectKey, jobId);
    }

    public EnhancedSerializedJobStatus getStatus_NT(String projectKey, String jobId) throws IOException, SQLException {
        SerializedJobStatus sjs = this.buildService.getStatusOrNull(projectKey, jobId);
        if (sjs == null) {
            JobSummary summary = this.dbService.getJobSummary(projectKey, jobId);
            if (summary == null) {
                throw new IllegalArgumentException("Unknown job " + projectKey + " / " + jobId);
            }
            if (!summary.stableState) {
                throw new IllegalArgumentException("Job state incoherent " + projectKey + " / " + jobId + " is not stable and not running");
            }
            File jobFolder = FlowJobUtils.jobFolder(false, projectKey, jobId);
            File statusFile = new File(jobFolder, "status.json");
            boolean removed = false;
            if (statusFile.exists()) {
                sjs = (SerializedJobStatus)JSON.parseFile((File)statusFile, SerializedJobStatus.class);
            } else {
                SerializedJobStatus fakeSJS = new SerializedJobStatus();
                fakeSJS.def = summary.def;
                fakeSJS.jobStartTime = summary.startTime;
                fakeSJS.jobEndTime = summary.endTime;
                sjs = fakeSJS;
                removed = true;
            }
            sjs.state = summary.state;
            EnhancedSerializedJobStatus esjs = new EnhancedSerializedJobStatus(sjs);
            esjs.removed = removed;
            esjs.stepRun = EnhancedSerializedJobStatus.StepJobStatus.create(summary);
            File runtimeFile = new File(jobFolder, "run-summary.json");
            if (runtimeFile.isFile()) {
                esjs.runtimeSummary = (JobRuntimeSummary)JSON.parseFile((File)runtimeFile, JobRuntimeSummary.class);
            }
            return esjs;
        }
        EnhancedSerializedJobStatus esjs = new EnhancedSerializedJobStatus(sjs);
        esjs.removed = false;
        return esjs;
    }

    public void addInitiator(EnhancedSerializedJobStatus esjs) throws IOException {
        esjs.initiator = this.usersService.getPublicUser(esjs.baseStatus.def.initiator);
    }

    public void clearLogsWithFilter_NT(String projectKey, String filter) throws Exception {
        for (JobSummary summary : this.listLastJobs_NT(projectKey, 100000000)) {
            if (!summary.stableState || summary.state == JobState.RUNNING) continue;
            try {
                boolean keep = true;
                switch (filter) {
                    case "finished": {
                        if (summary.state != JobState.DONE && summary.state != JobState.ABORTED && summary.state != JobState.FAILED) break;
                        keep = false;
                        break;
                    }
                    case "failed": {
                        if (summary.state != JobState.ABORTED && summary.state != JobState.FAILED) break;
                        keep = false;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Filter " + filter + " doesn't exist");
                    }
                }
                if (keep) continue;
                DKUFileUtils.deleteDirectory((File)FlowJobUtils.jobFolder(false, projectKey, summary.def.id));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to delete job folder", (Throwable)e);
            }
        }
    }

    public void clearLogs_NT(String projectKey, String jobId) throws IOException, SQLException {
        JobSummary summary = this.dbService.getJobSummary(projectKey, jobId);
        if (summary == null) {
            throw new IllegalArgumentException("Unknown job " + projectKey + " / " + jobId);
        }
        if (!summary.stableState) {
            throw new IllegalArgumentException("Cannot clear logs for a running job");
        }
        DKUFileUtils.deleteDirectory((File)FlowJobUtils.jobFolder(false, projectKey, jobId));
    }

    public void clearTimestampsForDataset(DatasetLocUtils.DatasetLoc loc) throws IOException, SQLException {
        try (DSSDBConnection conn = this.flowStateInternalDB.acquireConnection();){
            this.flowStateInternalDB.clearForDataset(conn, loc.getFullName());
        }
    }

    public void clearTimestampsForDatasetPartitions(DatasetLocUtils.DatasetLoc loc, List<String> partitionIds) throws IOException, SQLException {
        try (DSSDBConnection conn = this.flowStateInternalDB.acquireConnection();){
            this.flowStateInternalDB.clearForDatasetPartitions(conn, loc.getFullName(), partitionIds);
        }
    }

    public FutureResponse<List<EnhancedSerializedJobStatus.YarnLog>> fetchYarnLogs(AuthCtx authCtx, String projectKey, String jobId) throws Exception {
        FetchYarnLogsThread ft = new FetchYarnLogsThread(authCtx, projectKey, jobId);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<List<EnhancedSerializedJobStatus.YarnLog>>>(){});
    }

    public void dumpStacksIfStillRunning_NT(String projectKey, String jobId) {
        try {
            SerializedJobStatus sjs = this.buildService.getStatusOrNull(projectKey, jobId);
            if (sjs != null) {
                int killPid;
                int n = killPid = sjs.jvmPid > 0 ? sjs.jvmPid : sjs.kernelPid;
                if (killPid <= 0) {
                    return;
                }
                logger.info((Object)("Getting stacks of PID " + killPid + " (kernelPid=" + sjs.kernelPid + " jvmPid=" + sjs.jvmPid + ")"));
                DKUtils.dumpJvmStacks((int)killPid, (File)LogsService.getJobFolder(projectKey, jobId));
            }
        }
        catch (DKUSecurityException | IOException e) {
            logger.warn((Object)("Unable to dump stacks of job " + projectKey + " / " + jobId), e);
        }
    }

    public static class JobSummary {
        public boolean stableState;
        public JobDef def;
        public JobState state;
        public long warningsCount;
        public long startTime;
        public long endTime;
        public String scenarioProjectKey;
        public String scenarioId;
        public String stepId;
        public String scenarioRunId;
        public String stepRunId;
        public int kernelPid;
    }

    private class FetchYarnLogsThread
    extends SimpleFutureThread<List<EnhancedSerializedJobStatus.YarnLog>> {
        private String projectKey;
        private String jobId;
        private FuturePayload futurePayload;

        public FetchYarnLogsThread(AuthCtx owner, String projectKey, String jobId) {
            super(owner);
            this.projectKey = projectKey;
            this.jobId = jobId;
            this.futurePayload = FuturePayload.newSimple((String)"fetch_yarn", (String)("Fetch yarn logs in job " + jobId));
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        protected List<EnhancedSerializedJobStatus.YarnLog> compute() throws Exception {
            ArrayList yarnLogs = Lists.newArrayList();
            File jobFolder = FlowJobUtils.jobFolder(false, this.projectKey, this.jobId);
            SerializedJobStatus sjs = FlowExecutionService2.this.buildService.getStatusOrNull(this.projectKey, this.jobId);
            if (sjs == null) {
                JobSummary summary = FlowExecutionService2.this.dbService.getJobSummary(this.projectKey, this.jobId);
                if (summary == null) {
                    throw new IllegalArgumentException("Unknown job " + this.projectKey + " / " + this.jobId);
                }
                if (!summary.stableState) {
                    throw new IllegalArgumentException("Job state incoherent " + this.projectKey + " / " + this.jobId + " is not stable and not running");
                }
                File statusFile = new File(jobFolder, "status.json");
                if (statusFile.exists()) {
                    sjs = (SerializedJobStatus)JSON.parseFile((File)statusFile, SerializedJobStatus.class);
                }
            }
            ArrayList activityIds = Lists.newArrayList();
            for (Map.Entry<String, SerializedJobActivityStatus> activity : sjs.activities.entrySet()) {
                if (!activity.getValue().state.isFinished()) continue;
                activityIds.add(activity.getKey());
            }
            logger.info((Object)("Found " + activityIds.size() + " activities to scan for Yarn applicationIds"));
            HadoopSettings hadoopSettings = new ClusterSelector().selectForProject(this.owner, this.projectKey).getHadoopSettings();
            YarnUtils yarnUtils = new YarnUtils(hadoopSettings);
            for (String activityId : activityIds) {
                File activityLogFile = new File(jobFolder, activityId + ".log");
                if (!activityLogFile.exists()) continue;
                try {
                    Set<String> yarnAppIds = this.scanYarnApplicationId(activityLogFile);
                    logger.info((Object)("Found " + yarnAppIds.size() + " Yarn apps for " + activityId + " : " + Joiner.on((String)", ").join(yarnAppIds)));
                    for (String yarnAppId : yarnAppIds) {
                        File yarnLogFile = new File(jobFolder, activityId + "." + yarnAppId + ".log");
                        if (!yarnLogFile.exists()) {
                            yarnUtils.tryFetchYarnLog(yarnAppId, yarnLogFile);
                        }
                        if (!yarnLogFile.exists()) continue;
                        yarnLogs.add(new EnhancedSerializedJobStatus.YarnLog(activityId, yarnAppId));
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to scan " + activityLogFile.getAbsolutePath() + " for Yarn application ids"), (Throwable)e);
                }
            }
            return yarnLogs;
        }

        private Set<String> scanYarnApplicationId(File activityLogFile) throws IOException {
            HashSet appIds = Sets.newHashSet();
            Pattern appIdPattern = Pattern.compile("^.*(application_[0-9]{13}_[0-9]{4}).*$");
            logger.info((Object)("Scan file " + activityLogFile.getAbsolutePath()));
            try (BufferedReader reader = new BufferedReader(new FileReader(activityLogFile));){
                String line = reader.readLine();
                while (line != null) {
                    Matcher matcher = appIdPattern.matcher(line);
                    if (matcher.matches()) {
                        appIds.add(matcher.group(1));
                    }
                    line = reader.readLine();
                }
            }
            return appIds;
        }
    }
}

