/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import com.dataiku.dip.contribs.PythonContrib;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.util.ParamDesc;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PythonContribProcessor
extends SingleRowProcessor
implements Processor {
    PythonContrib contrib;
    PythonContrib.PythonContribInstance instance;
    PythonContribParams params;

    public PythonContribProcessor(PythonContrib contrib, PythonContribParams params) {
        this.contrib = contrib;
        this.params = params;
    }

    public ProcessorMeta<PythonContribProcessor, PythonContribParams> getMeta() {
        return new PythonMeta();
    }

    public void init() throws Exception {
        this.instance = this.contrib.getInstance();
        HashSet<String> columns = new HashSet<String>();
        for (Map.Entry entry : this.params.entrySet()) {
            if (((String)entry.getKey()).equals("targetColumn")) continue;
            PythonContrib.PythonParameter param = this.contrib.parameters.get(entry.getKey());
            switch (param.type) {
                case COLUMN: {
                    columns.add((String)entry.getValue());
                    break;
                }
                case VALUE: {
                    this.instance.set(param.name, (String)entry.getValue());
                }
            }
        }
        Column last = null;
        for (Column col : this.getColumnFactory().columns()) {
            if (!columns.contains(col.getName())) continue;
            last = col;
        }
        if (last != null) {
            this.getColumnFactory().columnAfter(last.getName(), this.params.getTargetColumn(), Processor.ProcessorRole.OUTPUT_COLUMN);
        }
    }

    public void processRow(Row row) throws Exception {
        for (PythonContrib.PythonParameter param : this.contrib.parameters.values()) {
            if (param.type != PythonContrib.ParameterType.COLUMN) continue;
            this.instance.set(param.name, row.get(this.getColumnFactory().column((String)this.params.get(param.name), Processor.ProcessorRole.INPUT_COLUMN)));
        }
        String result = this.instance.run();
        row.put(this.getColumnFactory().column(this.params.getTargetColumn(), Processor.ProcessorRole.OUTPUT_COLUMN), result);
    }

    public void postProcess() throws Exception {
    }

    public static class PythonContribParams
    extends HashMap<String, String>
    implements StepParams {
        private static final long serialVersionUID = 1L;

        public void validate() throws IllegalArgumentException {
        }

        public String getTargetColumn() {
            return (String)this.get("targetColumn");
        }
    }

    public class PythonMeta
    extends ProcessorMeta<PythonContribProcessor, PythonContribParams> {
        @Override
        public String getName() {
            return PythonContribProcessor.this.contrib.name;
        }

        @Override
        public Category getCategory() {
            return Category.MISC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CUSTOM, ProcessorTag.MISC});
        }

        @Override
        public Class<PythonContribParams> stepParamClass() {
            return PythonContribParams.class;
        }

        public String paramDescName(String typeName) {
            if (typeName.equals("str")) {
                return "string";
            }
            if (typeName.equals("unicode")) {
                return "string";
            }
            if (typeName.equals("int")) {
                return "int";
            }
            if (typeName.equals("float")) {
                return "double";
            }
            return "string";
        }

        @Override
        public ProcessorDesc describe(String language) {
            ProcessorDesc desc = ProcessorDesc.withGenericForm(this.getName(), PythonContribProcessor.this.contrib.title);
            for (PythonContrib.PythonParameter param : PythonContribProcessor.this.contrib.parameters.values()) {
                if (param.type == PythonContrib.ParameterType.COLUMN) {
                    desc = desc.withMNEColParam(param.name, param.name);
                    continue;
                }
                if (param.type != PythonContrib.ParameterType.VALUE) continue;
                desc = desc.withParam(new ParamDesc(param.name, this.paramDescName(param.typeName)).withDefaultValue(param.defaultValue).withLabel(param.name));
            }
            desc.withMNESParam("targetColumn", this.translate(language, "SHAKER.PROCESSOR.PythonContribProcessor.DESCRIPTION.TARGET_COLUMN", "Target Column"));
            return desc;
        }

        @Override
        public PythonContribProcessor build(PythonContribParams pythonContribParams) throws Exception {
            PythonContribProcessor processor = new PythonContribProcessor(PythonContribProcessor.this.contrib, pythonContribParams);
            return processor;
        }
    }
}

