/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.yarnaware;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.resources.YarnPythonBinResourcesGatherer;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobBuilder;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.yarnaware.SparkYarnClusterHelper;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jcraft.jsch.JSchException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class SparkYarnAwareJobHelper<T extends SparkJob>
extends SparkJobHelper<T> {
    private final UserImpersonationTarget initialImpersonationTarget;
    protected ComputeResourceUsage cru;
    private static Logger logger = Logger.getLogger((String)"dku.spark.helper");

    protected SparkYarnAwareJobHelper(String projectKey, AuthCtx authCtx, SparkSettings sparkSettings, HadoopSettings hadoopSettings, UserImpersonationTarget impersonationTarget) {
        super(projectKey, authCtx, sparkSettings, hadoopSettings);
        this.initialImpersonationTarget = impersonationTarget;
    }

    private UserImpersonationTarget getImpersonationTarget() throws DKUSecurityException {
        if (this.initialImpersonationTarget != null) {
            return this.initialImpersonationTarget;
        }
        IImpersonationResolverService impersonationResolverService = (IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class);
        return impersonationResolverService.getTargetUser(this.projectKey, this.authCtx);
    }

    protected boolean runsInClusterMode(T job) {
        return this.runsInClusterMode(((SparkJob)job).conf);
    }

    protected boolean runsInClusterMode(List<SimpleKeyValue> conf) {
        String sparkMaster = "";
        String sparkDeployMode = "";
        String dkuClusterMode = "";
        for (SimpleKeyValue kv : conf) {
            if ("spark.master".equals(kv.key)) {
                sparkMaster = StringUtils.defaultIfBlank((String)kv.value, (String)"");
            }
            if ("spark.submit.deployMode".equals(kv.key)) {
                sparkDeployMode = StringUtils.defaultIfBlank((String)kv.value, (String)"");
            }
            if (!"dku.spark.submit.deployMode".equals(kv.key)) continue;
            dkuClusterMode = StringUtils.defaultIfBlank((String)kv.value, (String)"");
        }
        if ("cluster".equals(dkuClusterMode)) {
            return true;
        }
        return this.runsInClusterMode(sparkMaster, sparkDeployMode);
    }

    protected boolean runsInClusterMode(String sparkMaster, String sparkDeployMode) {
        if (sparkMaster.startsWith("local")) {
            return false;
        }
        if ("yarn-client".equals(sparkMaster)) {
            return false;
        }
        if ("yarn-cluster".equals(sparkMaster)) {
            return true;
        }
        if ("yarn".equals(sparkMaster) && "cluster".equals(sparkDeployMode)) {
            return true;
        }
        return sparkMaster.startsWith("k8s://") && "cluster".equals(sparkDeployMode);
    }

    public SparkJobHelper.SparkJobContext setupRunUsingCluster(SparkJobHelper.RunMode runMode, SparkJobBuilder jobBuilder, final File processRunDir, T job, EnvironmentStash stash, SparkJobExecEnv jobExecEnv, CodeEnvModel.UsedCodeEnvRef codeEnvRef) throws InstantiationException, IllegalAccessException, IOException, DKUSecurityException, CodedException, JSchException, InterruptedException {
        String uploaded;
        String zipName;
        final SparkYarnClusterHelper yarnClusterHelper = new SparkYarnClusterHelper(this.authCtx, "recipe", this.sparkSettings.yarnClusterSettings, ((SparkJob)job).conf);
        final String jobId = yarnClusterHelper.getObjectId();
        final RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = true;
        envResource.exchange = yarnClusterHelper.getExchangeBox();
        envResource.jobId = jobId;
        envResource.jobExecEnv = jobExecEnv;
        envResource.callContextStop = this.shouldCallContextStopNonetheless();
        envResource.dssVersion = DKUApp.getDSSVersion();
        String mainFile = null;
        for (SparkJob.SparkFilesList list : ((SparkJob)job).getFileLists()) {
            if ("jars".equals(list.name()) && runMode == SparkJobHelper.RunMode.SPARKR) {
                logger.info((Object)"Not uploading jars, since SparkR doesn't support it");
                continue;
            }
            Iterator<File> files = list.get();
            logger.info((Object)("Upload " + files.size() + " files for " + list.name()));
            ArrayList uploadedFiles = Lists.newArrayList();
            for (String string : yarnClusterHelper.dedup((List<String>)((Object)files), ((SparkJob)job).file)) {
                if (this.doUploadForDistribution(list.name())) {
                    String string2 = yarnClusterHelper.uploadKeepNameToUriUseCache(new File(string));
                    uploadedFiles.add(string2);
                    continue;
                }
                uploadedFiles.add(string);
            }
            list.set(uploadedFiles);
        }
        if (StringUtils.isNotBlank((String)((SparkJob)job).file)) {
            if (this.doUploadForDistribution("main")) {
                String uploaded2 = yarnClusterHelper.uploadKeepName(new File(((SparkJob)job).file));
                mainFile = yarnClusterHelper.getURIForUploadedPath(uploaded2);
            } else {
                mainFile = ((SparkJob)job).file;
            }
        }
        ((SparkJob)job).file = mainFile;
        HashMap pathToZip = Maps.newHashMap();
        HashMap pyFileToZip = Maps.newHashMap();
        for (File folder : jobBuilder.getExtraFlatFolders()) {
            this.zipOneFolderForYarnCluster(pathToZip, processRunDir, folder, false, null, false);
        }
        for (File folder : jobBuilder.getExtraRecursiveFolders()) {
            this.zipOneFolderForYarnCluster(pathToZip, processRunDir, folder, true, null, false);
        }
        File pluginsFolder = new File(ApplicationConfigurator.getBaseFolder(), "plugins");
        final Set<String> excludedPluginFolders = this.buildExcludedPluginFoldersList(pluginsFolder);
        logger.info((Object)("Zip plugins with exclusion of " + Joiner.on((String)",").join(excludedPluginFolders)));
        this.zipOneFolderForYarnCluster(pathToZip, processRunDir, pluginsFolder, true, new Predicate<String>(){

            public boolean apply(String path) {
                return !excludedPluginFolders.contains(path);
            }
        }, false);
        envResource.plugins = pluginsFolder.getAbsolutePath();
        switch (runMode) {
            case PYSPARK: {
                envResource.python = new RemoteRunEnvDef.PythonEnvResource();
                Map<String, Boolean> pyFiles = this.collectLibrariesForPythonPath(true, stash, true);
                for (Map.Entry<String, Boolean> entry : pyFiles.entrySet()) {
                    File f = new File(entry.getKey());
                    this.zipOneFolderForYarnCluster(pyFileToZip, processRunDir, f, true, null, entry.getValue());
                }
                break;
            }
            case SPARKR: {
                envResource.r = new RemoteRunEnvDef.REnvResource();
                File rFolder = "1".equals(System.getenv("DSS_DEV")) ? new File(new File(ApplicationConfigurator.getInstallFolder(), "dist"), "R") : new File(ApplicationConfigurator.getInstallFolder(), "R");
                for (String packageName : new String[]{"dataiku", "dataiku.spark", "dataiku.spark2"}) {
                    File packageFolder = new File(rFolder, packageName);
                    if (!packageFolder.exists()) continue;
                    this.zipOneFolderForYarnCluster(pathToZip, processRunDir, packageFolder, true, null, false);
                    envResource.r.packages.add(new SimpleKeyValue(packageName, packageFolder.getAbsolutePath()));
                }
                break;
            }
        }
        envResource.zippedFolders = pathToZip;
        IImpersonationResolverService impersonationResolverService = (IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class);
        if (impersonationResolverService.isEnabled()) {
            UserImpersonationTarget userImpersonationTarget = this.getImpersonationTarget();
            this.setupProxyUser(job, userImpersonationTarget.hadoopUser, true);
            for (SimpleKeyValue kv : ((SparkJob)job).conf) {
                if (!"spark.yarn.stagingDir".equals(kv.key)) continue;
                logger.info((Object)"Append user name to staging dir");
                kv.value = kv.value + "/" + userImpersonationTarget.hadoopUser;
            }
        } else {
            this.setupProxyUser(job, SparkJobHelper.safeGetCurrentShortUserName(), false);
        }
        this.cleanupConf(job, true);
        this.adjustEnvVars(stash);
        this.adjustPythonAndRProperties(stash, job);
        final Closeable closeable = this.createAdditionalContextElement(job, runMode, processRunDir, codeEnvRef, stash, true);
        for (Map.Entry zip : pathToZip.entrySet()) {
            zipName = (String)zip.getValue();
            logger.info((Object)("Zipped '" + (String)zip.getKey() + "' (file) and added as " + zipName));
            if (this.doUploadForDistribution("zip")) {
                uploaded = yarnClusterHelper.uploadKeepName(new File(processRunDir, zipName));
                ((SparkJob)job).nonSecretGlobalFiles.add(yarnClusterHelper.getURIForUploadedPath(uploaded));
                continue;
            }
            ((SparkJob)job).nonSecretGlobalFiles.add(new File(processRunDir, zipName).getAbsolutePath());
        }
        for (Map.Entry zip : pyFileToZip.entrySet()) {
            zipName = (String)zip.getValue();
            logger.info((Object)("Zipped '" + (String)zip.getKey() + "' (pyFile) and added as " + zipName));
            if (this.doUploadForDistribution("zip")) {
                uploaded = yarnClusterHelper.uploadKeepName(new File(processRunDir, zipName));
                ((SparkJob)job).pyFiles.add(yarnClusterHelper.getURIForUploadedPath(uploaded));
                continue;
            }
            ((SparkJob)job).pyFiles.add(new File(processRunDir, zipName).getAbsolutePath());
        }
        yarnClusterHelper.setupEnvVarsForReachingDSS(stash);
        stash.env.put("DKU_BACKEND_HOST", RemoteRunNetworkingUtils.getBackendHost());
        stash.env.put("DKU_BACKEND_PORT", RemoteRunNetworkingUtils.getBackendRPCPort());
        stash.env.put("DKU_BACKEND_PROTOCOL", RemoteRunNetworkingUtils.getBackendRPCProtocol());
        stash.env.put("DKU_BASE_PORT", RemoteRunNetworkingUtils.getBasePort());
        stash.env.put("DKU_BASE_PROTOCOL", RemoteRunNetworkingUtils.getBaseProtocol());
        stash.env.put("DKU_SERVER_HOST", RemoteRunNetworkingUtils.getServerHost());
        stash.env.put("DKU_SERVER_PORT", String.valueOf(RemoteRunNetworkingUtils.getServerPort()));
        stash.env.put("DKU_SERVER_KIND", String.valueOf(RemoteRunNetworkingUtils.getServerKind()));
        stash.env.put("DKU_SERVER_PROTOCOL", RemoteRunNetworkingUtils.getServerProtocol());
        if (EncryptedRPC.enabled()) {
            stash.env.put("DKU_SERVER_CERT", EncryptedRPC.getPEMCertificateText());
        }
        stash.copyToRemoteRunEnvDef(envResource, false, true, false);
        logger.info((Object)"Store environment variables and exchange box in file");
        File file = new File(processRunDir, "remote-run-env-def.json");
        FileUtils.write((File)file, (CharSequence)JSON.json((Object)envResource));
        if (this.doUploadForDistribution("env")) {
            String uploaded3 = yarnClusterHelper.uploadKeepName(file);
            ((SparkJob)job).secretDriverFiles.add(yarnClusterHelper.getURIForUploadedPath(uploaded3));
        } else {
            ((SparkJob)job).secretDriverFiles.add(file.getAbsolutePath());
        }
        if (!jobExecEnv.additionalLocalJars.isEmpty()) {
            logger.info((Object)("Got " + jobExecEnv.additionalLocalJars.size() + " additional jars for spark"));
            ((SparkJob)job).jars.addAll(jobExecEnv.additionalLocalJars);
        }
        RemoteRunsRegistry.add(jobId, this.authCtx, this.projectKey, processRunDir.getAbsolutePath(), processRunDir.getAbsolutePath(), RemoteRunsRegistry.ExecutionType.SPARK, "", "", jobBuilder.getReadablePaths(), jobBuilder.getWritablePaths(), Collections.emptyList());
        RemoteRunsRegistry.get((String)jobId).envResource = envResource;
        return new SparkJobHelper.SparkJobContext(){

            @Override
            public AuthCtx getAuthCtx() {
                return SparkYarnAwareJobHelper.this.authCtx;
            }

            @Override
            public void close() throws Exception {
                if (closeable != null) {
                    closeable.close();
                }
                RemoteRunsRegistry.remove(jobId);
                yarnClusterHelper.close();
            }

            @Override
            public File getLocalRunDir() {
                return processRunDir;
            }

            @Override
            public String getJobId() {
                return jobId;
            }

            @Override
            public boolean impersonatesRemotely() {
                return true;
            }

            @Override
            public String runAsHadoopUser() throws IOException {
                return SparkJobHelper.safeGetLoginShortUserName();
            }

            @Override
            public RemoteRunEnvDef getRemoteRunEnvDef() {
                return envResource;
            }

            @Override
            public boolean driverRunsRemotely() {
                return true;
            }

            @Override
            public int doubleCheckRunStarted() throws Exception {
                return 0;
            }

            @Override
            public ComputeResourceUsage getComputeResourceUsage() {
                return SparkYarnAwareJobHelper.this.cru;
            }
        };
    }

    protected boolean shouldCallContextStopNonetheless() {
        return false;
    }

    protected boolean doUploadForDistribution(String type) {
        return true;
    }

    private void adjustPythonAndRProperties(EnvironmentStash stash, T job) {
        String pysparkPythonEnv = stash.env.get("PYSPARK_PYTHON");
        String pysparkDriverPythonEnv = stash.env.get("PYSPARK_DRIVER_PYTHON");
        String pysparkPythonProp = ((SparkJob)job).getConfValue("spark.pyspark.python");
        String pysparkDriverPythonProp = ((SparkJob)job).getConfValue("spark.pyspark.driver.python");
        String pysparkPythonYarn = ((SparkJob)job).getConfValue("spark.yarn.appMasterEnv.PYSPARK_PYTHON");
        String pysparkDriverPythonYarn = ((SparkJob)job).getConfValue("spark.yarn.appMasterEnv.PYSPARK_DRIVER_PYTHON");
        String pysparkPython = pysparkPythonYarn;
        if (StringUtils.isNotBlank((String)pysparkPythonEnv)) {
            pysparkPython = pysparkPythonEnv;
        }
        if (StringUtils.isNotBlank((String)pysparkPythonProp)) {
            pysparkPython = pysparkPythonProp;
        }
        String pysparkDriverPython = pysparkDriverPythonYarn;
        if (StringUtils.isNotBlank((String)pysparkDriverPythonEnv)) {
            pysparkDriverPython = pysparkDriverPythonEnv;
        }
        if (StringUtils.isNotBlank((String)pysparkDriverPythonProp)) {
            pysparkDriverPython = pysparkDriverPythonProp;
        }
        logger.info((Object)("Will run python with pysparkPython=" + pysparkPython + " and pysparkDriverPython=" + pysparkDriverPython));
        pysparkDriverPython = StringUtils.defaultIfBlank((String)pysparkPython, (String)pysparkDriverPython);
        if (StringUtils.isNotBlank((String)pysparkPython)) {
            stash.env.put("PYSPARK_PYTHON", pysparkPython);
            ((SparkJob)job).conf.add(new SimpleKeyValue("spark.pyspark.python", pysparkPython));
            ((SparkJob)job).conf.add(new SimpleKeyValue("spark.yarn.appMasterEnv.PYSPARK_PYTHON", pysparkPython));
        }
        if (StringUtils.isNotBlank((String)pysparkDriverPython)) {
            stash.env.put("PYSPARK_DRIVER_PYTHON", pysparkDriverPython);
            ((SparkJob)job).conf.add(new SimpleKeyValue("spark.pyspark.driver.python", pysparkDriverPython));
            ((SparkJob)job).conf.add(new SimpleKeyValue("spark.yarn.appMasterEnv.PYSPARK_DRIVER_PYTHON", pysparkDriverPython));
        }
    }

    protected void cleanupConf(T job, boolean isYarnCluster) {
        if (isYarnCluster) {
            HashSet keysToRemove = Sets.newHashSet((Object[])new String[]{"spark.yarn.security.tokens.hive.enabled", "spark.yarn.security.credentials.hadoopfs.enabled", "spark.security.credentials.hive.enabled", "spark.security.credentials.hadoopfs.enabled"});
            HashSet toRemove = Sets.newHashSet();
            for (SimpleKeyValue kv : ((SparkJob)job).conf) {
                if (!keysToRemove.contains(kv.key)) continue;
                toRemove.add(kv);
            }
            for (SimpleKeyValue kv : toRemove) {
                ((SparkJob)job).conf.remove(kv);
            }
        }
    }

    protected abstract void adjustEnvVars(EnvironmentStash var1);

    protected abstract void setupProxyUser(T var1, String var2, boolean var3);

    private String zipOneFolderForYarnCluster(Map<String, String> pathToZip, File processRunDir, File folder, boolean recursive, Predicate<String> filter, boolean isPackage) throws IOException {
        String folderPath = folder.getAbsolutePath();
        if (pathToZip.containsKey(folderPath)) {
            return pathToZip.get(folderPath);
        }
        String zipName = this.zipFolderForYarn(processRunDir, folder, recursive, filter, isPackage);
        pathToZip.put(folderPath, zipName);
        return zipName;
    }

    private String zipOneFolderForYarnClient(File processRunDir, File folder, boolean recursive, Predicate<String> filter, boolean isPackage) throws IOException {
        String zipName = this.zipFolderForYarn(processRunDir, folder, recursive, filter, isPackage);
        return new File(processRunDir, zipName).getAbsolutePath();
    }

    private String zipFolderForYarn(File processRunDir, File folder, boolean recursive, Predicate<String> filter, boolean isPackage) throws IOException {
        String zipName = (recursive ? "rec" : "flat") + "-" + SecretKeyGenerator.generate((int)8) + ".zip";
        File zipFile = new File(processRunDir, zipName);
        String basePath = isPackage ? folder.getName() + "/" : "";
        ZipUnzipDir.zipDirectory(basePath, folder, zipFile, recursive, filter);
        return zipName;
    }

    protected abstract Closeable createAdditionalContextElement(T var1, SparkJobHelper.RunMode var2, File var3, CodeEnvModel.UsedCodeEnvRef var4, EnvironmentStash var5, boolean var6) throws IOException, InterruptedException;

    public SparkJobHelper.SparkJobContext setupRunUsingClient(SparkJobHelper.RunMode runMode, SparkJobBuilder jobBuilder, final File runDir, T job, EnvironmentStash stash, SparkJobExecEnv jobExecEnv, CodeEnvModel.UsedCodeEnvRef codeEnvRef) throws Exception {
        IImpersonationResolverService impersonationResolverService;
        List<File> extraRecursiveFolders;
        List<File> extraFlatFolders;
        final String jobId = SecretKeyGenerator.generate((int)8);
        final RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = false;
        envResource.jobId = jobId;
        envResource.jobExecEnv = jobExecEnv;
        stash.env.put("DKU_BACKEND_HOST", RemoteRunNetworkingUtils.getBackendHost());
        stash.env.put("DKU_BACKEND_PORT", RemoteRunNetworkingUtils.getBackendRPCPort());
        stash.env.put("DKU_BACKEND_PROTOCOL", RemoteRunNetworkingUtils.getBackendRPCProtocol());
        stash.env.put("DKU_BASE_PORT", RemoteRunNetworkingUtils.getBasePort());
        stash.env.put("DKU_BASE_PROTOCOL", RemoteRunNetworkingUtils.getBaseProtocol());
        stash.env.put("DKU_SERVER_HOST", RemoteRunNetworkingUtils.getServerHost());
        stash.env.put("DKU_SERVER_PORT", String.valueOf(RemoteRunNetworkingUtils.getServerPort()));
        stash.env.put("DKU_SERVER_KIND", String.valueOf(RemoteRunNetworkingUtils.getServerKind()));
        stash.env.put("DKU_SERVER_PROTOCOL", RemoteRunNetworkingUtils.getServerProtocol());
        if (EncryptedRPC.enabled()) {
            stash.env.put("DKU_SERVER_CERT", EncryptedRPC.getPEMCertificateText());
        }
        if (!(extraFlatFolders = jobBuilder.getExtraFlatFolders()).isEmpty()) {
            FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.projectKey, false, extraFlatFolders.toArray(new File[0]));
        }
        if (!(extraRecursiveFolders = jobBuilder.getExtraRecursiveFolders()).isEmpty()) {
            FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.projectKey, true, extraRecursiveFolders.toArray(new File[0]));
        }
        if (runMode == SparkJobHelper.RunMode.PYSPARK) {
            ((SparkJob)job).pyFiles.addAll(this.getPyFilesForClient(runDir, stash, true));
        }
        final String hadoopUser = (impersonationResolverService = (IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class)).isEnabled() ? this.getImpersonationTarget().hadoopUser : SparkJobHelper.safeGetCurrentShortUserName();
        this.cleanupConf(job, false);
        final Closeable additionalCloseableContext = this.createAdditionalContextElement(job, runMode, runDir, codeEnvRef, stash, false);
        stash.copyToRemoteRunEnvDef(envResource, false, true, false);
        logger.info((Object)"Store environment variables in local file for executions via spark-submit");
        File envVarsJson = new File(runDir, "remote-run-env-def.json");
        FileUtils.write((File)envVarsJson, (CharSequence)JSON.json((Object)envResource));
        if (!jobExecEnv.additionalLocalJars.isEmpty()) {
            logger.info((Object)("Got " + jobExecEnv.additionalLocalJars.size() + " additional jars for spark"));
            ((SparkJob)job).jars.addAll(jobExecEnv.additionalLocalJars);
            ((SparkJob)job).conf.add(new SimpleKeyValue("spark.driver.extraClassPath", Joiner.on((String)",").join(jobExecEnv.additionalLocalJars)));
        }
        return new SparkJobHelper.SparkJobContext(){

            @Override
            public AuthCtx getAuthCtx() {
                return SparkYarnAwareJobHelper.this.authCtx;
            }

            @Override
            public void close() throws Exception {
                if (additionalCloseableContext != null) {
                    additionalCloseableContext.close();
                }
            }

            @Override
            public File getLocalRunDir() {
                return runDir;
            }

            @Override
            public String getJobId() {
                return jobId;
            }

            @Override
            public boolean impersonatesRemotely() {
                return false;
            }

            @Override
            public String runAsHadoopUser() throws IOException {
                return hadoopUser;
            }

            @Override
            public RemoteRunEnvDef getRemoteRunEnvDef() {
                return envResource;
            }

            @Override
            public boolean driverRunsRemotely() {
                return envResource.runsRemotely;
            }

            @Override
            public int doubleCheckRunStarted() throws Exception {
                return 0;
            }

            @Override
            public ComputeResourceUsage getComputeResourceUsage() {
                return SparkYarnAwareJobHelper.this.cru;
            }
        };
    }

    public List<String> getPyFilesForClient(File runDir, EnvironmentStash stash, boolean removeFromStash) throws IOException {
        ArrayList ret = Lists.newArrayList();
        Map<String, Boolean> pyFiles = this.collectLibrariesForPythonPath(false, stash, removeFromStash);
        for (Map.Entry<String, Boolean> pyFile : pyFiles.entrySet()) {
            File f = new File(pyFile.getKey());
            String zip = this.zipOneFolderForYarnClient(runDir, f, true, null, pyFile.getValue());
            ret.add(zip);
        }
        return ret;
    }

    public Map<String, Boolean> collectLibrariesForPythonPath(boolean withDataikuPackage, EnvironmentStash stash, boolean removeFromStash) {
        String pythonLibFolderPath;
        File pythonLibFolder;
        HashMap libs = Maps.newHashMap();
        if (withDataikuPackage) {
            File pythonFolder = "1".equals(System.getenv("DSS_DEV")) ? new File(new File(new File(ApplicationConfigurator.getInstallFolder(), "src"), "main"), "python") : new File(ApplicationConfigurator.getInstallFolder(), "python");
            for (String packageName : YarnPythonBinResourcesGatherer.PYTHON_PACKAGES_TO_SEND) {
                File packageFolder = new File(pythonFolder, packageName);
                libs.put(packageFolder.getAbsolutePath(), true);
            }
        }
        if ((pythonLibFolder = new File(pythonLibFolderPath = ApplicationConfigurator.getBaseFolder() + "/lib/python")).exists()) {
            libs.put(pythonLibFolder.getAbsolutePath(), false);
        }
        HashSet toRemove = Sets.newHashSet();
        for (String path : stash.pythonPath) {
            File folder = new File(path);
            if (!folder.exists() || !folder.isDirectory()) continue;
            libs.put(folder.getAbsolutePath(), false);
            toRemove.add(path);
        }
        if (removeFromStash) {
            stash.pythonPath.removeAll(toRemove);
        }
        return libs;
    }

    public void setComputeResourceUsage(ComputeResourceUsage cru) {
        this.cru = cru;
    }
}

