/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.PostgresLikeSQLDialect;
import com.dataiku.dip.sql.RowSizeLimiter;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import java.util.List;
import java.util.Map;

public class YellowbrickSQLDialect
extends PostgresLikeSQLDialect {
    public static final String ID = "Yellowbrick";

    @Override
    public int getMaxPossibleVarcharLen() {
        return 64000;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    public boolean supportsIndexingOnTemporaryTables() {
        return false;
    }

    @Override
    public boolean needsAstTranslationChecking() {
        return true;
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, 5, "smallint", new Integer[0]);
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 6, "float4", new Integer[]{7, 2});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "float8", new Integer[]{7, 2});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 2014, "timestamptz", new Integer[]{91, 93});
            }
            case DATEONLY: {
                return new DSSTypeSQLMapping(Type.DATEONLY, 91, "date", new Integer[]{93, 2014});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "timestamp", new Integer[]{91, 2014});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public void setDefaultLengthForSchemaColumn(Schema schema, List<SchemaColumn> indexColumns, InfoMessage.InfoMessages messages) {
        RowSizeLimiter limiter = new RowSizeLimiter(ID, DatasetCodes.WARN_DATASET_YELLOWBRICK_SCHEMA_TOO_LARGE, 64000, 4, false);
        limiter.setDefaultLengthForSchemaColumn(schema, indexColumns, messages);
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        abilities.put(SQLAggregateType.CONCAT_DISTINCT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        return abilities;
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new YellowbrickLikeEscapeOperator(QueryUtils.OperatorType.CONTAINS, false, true));
        this.addOperator(new YellowbrickLikeEscapeOperator(QueryUtils.OperatorType.STARTS_WITH, false, true));
        this.addOperator(new YellowbrickLikeEscapeOperator(QueryUtils.OperatorType.ENDS_WITH, false, true));
        this.addOperator(new GenericSQLDialect.SimpleTernaryFunction(QueryUtils.OperatorType.SPLIT_PART, "SPLIT_PART(", ")", false));
        this.removeOperator(QueryUtils.OperatorType.FACT);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_REPLACE, "REGEXP_REPLACE", QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return YellowbrickSQLDialect.this.generateRegExpReplace(this, args);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_SUBSTR, "REGEXP_SUBSTR", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return YellowbrickSQLDialect.this.generateRegExpSubstr(this, args, "REGEXP_EXTRACT");
            }
        });
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.BOOLEAN && exprType == Type.STRING) {
            return "CASE WHEN (" + expr + ") IS NULL OR CAST(" + expr + " AS VARCHAR(100)) = '' THEN NULL ELSE CAST(" + expr + " AS VARCHAR(100)) ~* '^" + this.booleanTrueValuesRegex + "$' END";
        }
        return super.cast(expr, exprType, requestedType, maxLength);
    }

    private class YellowbrickLikeEscapeOperator
    extends GenericSQLDialect.LikeEscapeOperator {
        public YellowbrickLikeEscapeOperator(QueryUtils.OperatorType type, boolean forceBoolean, boolean specifyEscape) {
            super(type, forceBoolean, specifyEscape, "\\");
        }

        @Override
        public String apply(QueryAst.Expr[] args) {
            if (args.length != 2) {
                throw new QueryUtils.SQLGenerationException("Yellowbrick only supports constants in LIKE expressions");
            }
            if (!(args[1] instanceof QueryAst.ConstExpr)) {
                throw new QueryUtils.SQLGenerationException("Yellowbrick only supports constants in LIKE expressions");
            }
            Object expr = ((QueryAst.ConstExpr)args[1]).value.toString();
            expr = ((String)expr).replace(this.escapeChar, this.escapeChar + this.escapeChar).replace("%", this.escapeChar + "%").replace("_", this.escapeChar + "_");
            switch (this.type) {
                case STARTS_WITH: {
                    expr = (String)expr + "%";
                    break;
                }
                case ENDS_WITH: {
                    expr = "%" + (String)expr;
                    break;
                }
                case CONTAINS: {
                    expr = "%" + (String)expr + "%";
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported operator implementation: " + String.valueOf((Object)this.type));
                }
            }
            return this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.LIKE.priority) + " LIKE " + YellowbrickSQLDialect.this.quoteString((String)expr);
        }
    }
}

