/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.FieldList;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Field {
    public String name;
    public String type;
    public String mode;
    public List<Field> fields;
    public String description;

    public static Field of(String name, String type) {
        Field field = new Field();
        field.name = name;
        field.type = type;
        return field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return Objects.equal((Object)this.name, (Object)field.name) && Objects.equal((Object)this.type, (Object)field.type) && Objects.equal((Object)this.mode, (Object)field.mode) && Objects.equal(this.fields, field.fields) && Objects.equal((Object)this.description, (Object)field.description);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.mode, this.fields, this.description});
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field toField() {
        LegacySQLTypeName typeName = LegacySQLTypeName.valueOf((String)this.type);
        Field.Builder fieldBuilder = this.fields == null ? com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field.newBuilder((String)this.name, (LegacySQLTypeName)typeName, (com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field[])new com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field[0]) : com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field.newBuilder((String)this.name, (LegacySQLTypeName)typeName, (FieldList)FieldList.of((Iterable)this.fields.stream().map(Field::toField).collect(Collectors.toList())));
        return fieldBuilder.build();
    }

    public String toSQLTypeString(boolean asArrayContent) {
        if ("REPEATED".equals(this.mode) && !asArrayContent) {
            return String.format("ARRAY<%s>", this.toSQLTypeString(true));
        }
        if (this.fields != null && !this.fields.isEmpty()) {
            ArrayList<String> fieldsDefs = new ArrayList<String>();
            for (Field field : this.fields) {
                String fieldType = field.toSQLTypeString(false);
                fieldsDefs.add(String.format("`%s` %s", field.name, fieldType));
            }
            return String.format("STRUCT<%s>", String.join((CharSequence)", ", fieldsDefs));
        }
        return this.type;
    }
}

