/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ExpressionUtils {
    public static final ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    public static final Boolean booleanMeaning = new Boolean();
    private static final Logger logger = Logger.getLogger((String)"dip.sql.expression.utils");

    public static Object getTypedObjectForComparison(String valueString, Type valueType) {
        if (valueType.isNumeric()) {
            if (valueType.isFloatingPoint()) {
                return Double.parseDouble(valueString);
            }
            return Long.parseLong(valueString);
        }
        if (valueType == Type.BOOLEAN) {
            return booleanMeaning.parse(valueString);
        }
        return valueString;
    }

    public static ExpressionBuilder getEqualityTest(ExpressionBuilder col, String valueString, Type valueType) {
        if (valueString == null) {
            return col.isnull();
        }
        if (StringUtils.isBlank((String)valueString) && valueType != Type.STRING) {
            return col.isnull();
        }
        if (valueType == Type.BOOLEAN) {
            if (booleanMeaning.parse(valueString)) {
                return col.isTrue();
            }
            return col.isTrue().not();
        }
        return col.eq(ExpressionUtils.getTypedObjectForComparison(valueString, valueType));
    }

    public static SchemaColumn getSchemaColumn(String columnName, Schema schema, List<ComputedColumn> computedColumns, Map<String, SchemaColumn> explicitColumns) {
        if (explicitColumns.containsKey(columnName)) {
            return explicitColumns.get(columnName);
        }
        return ExpressionUtils.getSchemaColumn(columnName, schema, computedColumns);
    }

    public static SchemaColumn getSchemaColumn(String columnName, Schema schema, List<ComputedColumn> computedColumns) {
        assert (columnName != null);
        assert (columnName.length() > 0);
        assert (schema != null);
        SchemaColumn schemaCol = schema.getColumn(columnName);
        if (schemaCol == null && computedColumns != null && !computedColumns.isEmpty()) {
            for (ComputedColumn cc : computedColumns) {
                if (!columnName.equals(cc.name)) continue;
                schemaCol = new SchemaColumn(cc.name, Type.forName((String)cc.type));
                break;
            }
        }
        if (schemaCol == null) {
            throw ErrorContext.iaef((String)"Column does not exist in input schema or in computed columns: %s", (Object)columnName, (Object[])new Object[0]);
        }
        return schemaCol;
    }

    public static ExpressionBuilder getColAsNumeric(String colName, Dataset source) {
        return ExpressionUtils.getColAsNumeric(colName, source.getSchema());
    }

    public static ExpressionBuilder getColAsNumeric(String colName, Schema sourceSchema) {
        SchemaColumn sc = sourceSchema.getColumn(colName);
        return ExpressionUtils.getColAsNumeric(colName, sc);
    }

    public static ExpressionBuilder getColAsNumeric(String colName, SchemaColumn sc) {
        ExpressionBuilder expr = ef.col(colName);
        if (sc.getType() == Type.BOOLEAN) {
            return expr.castToInt();
        }
        if (!sc.getType().isNumeric()) {
            return expr.castToFloat();
        }
        return expr;
    }

    public static ExpressionBuilder getColAsFloatingPoint(String colName, Dataset source) {
        return ExpressionUtils.getColAsFloatingPoint(colName, source.getSchema());
    }

    public static ExpressionBuilder getColAsFloatingPoint(String colName, Schema sourceSchema) {
        SchemaColumn sc = sourceSchema.getColumn(colName);
        return ExpressionUtils.getColAsFloatingPoint(colName, sc);
    }

    public static ExpressionBuilder getColAsFloatingPoint(String colName, SchemaColumn sc) {
        ExpressionBuilder expr = ef.col(colName);
        if (sc.getType() == Type.BOOLEAN) {
            return expr.castToInt().castToFloat();
        }
        if (sc.getType() != Type.DOUBLE && sc.getType() != Type.FLOAT) {
            return expr.castToFloat();
        }
        return expr;
    }

    public static ExpressionBuilder getColAsString(String colName, Dataset source, SQLDialect dialect) {
        SchemaColumn sc = source.getSchema().getColumn(colName);
        return ExpressionUtils.getColAsString(colName, sc, dialect);
    }

    public static ExpressionBuilder getColAsString(String colName, SchemaColumn sc, SQLDialect dialect) {
        ExpressionBuilder expr = ef.col(colName);
        if (sc.getType() != Type.STRING) {
            return expr.castToString(dialect.getDefaultVarcharLen());
        }
        return expr;
    }

    public static ExpressionBuilder getAdjustedColumn(ExpressionBuilder col, String columnName, Dataset dataset, SQLDialect dialect) {
        Schema schema = dataset.getSchema();
        if (schema == null) {
            throw new QueryUtils.SQLGenerationException("Dataset '" + dataset.getFullName() + "' has no schema");
        }
        SchemaColumn sc = schema.getColumn(columnName);
        return ExpressionUtils.getAdjustedColumn(col, sc, dataset, dialect);
    }

    public static DatasetHandler.DatasetParams getTimezoneConfig(Dataset dataset) {
        if (DatasetInspector.isSQLOrHive(dataset)) {
            return dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        }
        return dataset.getParams();
    }

    public static ExpressionBuilder getAdjustedColumn(ExpressionBuilder col, SchemaColumn sc, Dataset dataset, SQLDialect dialect) {
        return ExpressionUtils.getAdjustedColumn(col, sc, ExpressionUtils.getTimezoneConfig(dataset), dataset.isManaged(), dialect);
    }

    public static ExpressionBuilder getAdjustedColumn(ExpressionBuilder col, String columnName, Schema schema, DatasetHandler.DatasetParams config, boolean isDatasetManaged, SQLDialect dialect) {
        return ExpressionUtils.getAdjustedColumn(col, schema.getColumn(columnName), config, isDatasetManaged, dialect);
    }

    public static ExpressionBuilder getAdjustedColumn(ExpressionBuilder col, SchemaColumn sc, DatasetHandler.DatasetParams config, boolean isDatasetManaged, SQLDialect dialect) {
        if (!DatasetInspector.isSQLOrHive(config) || sc == null) {
            return col;
        }
        ExpressionBuilder adjusted = ExpressionUtils.adjustCastTimezoneIfNeeded(col, sc, config, isDatasetManaged, dialect);
        if (adjusted != null) {
            return adjusted;
        }
        if (dialect.needCast(sc, isDatasetManaged)) {
            col = dialect.cast(sc, col);
        }
        return col;
    }

    public static ExpressionBuilder adjustCastTimezoneIfNeeded(ExpressionBuilder col, SchemaColumn sc, DatasetHandler.DatasetParams config, boolean isDatasetManaged, SQLDialect dialect) {
        if (sc.isUpcastedTimestampTz(isDatasetManaged)) {
            String assumedTzForUnknownTz = ((AbstractSQLDatasetHandler.AbstractSQLConfig)config).getAssumedDBTzForUnknownTz();
            if (assumedTzForUnknownTz == null || assumedTzForUnknownTz.length() == 0) {
                assumedTzForUnknownTz = DateTimeZone.getDefault().getID();
            }
            return dialect.supportsFromTimezoneNtzOperator() ? col.convertFromTzWithNtz(assumedTzForUnknownTz) : col.convertFromTz(assumedTzForUnknownTz);
        }
        return null;
    }

    public static boolean columnNeedsAdjustment(SchemaColumn sc, DatasetHandler.DatasetParams config, boolean isDatasetManaged, SQLDialect dialect) {
        if (!DatasetInspector.isSQLOrHive(config) || sc == null) {
            return false;
        }
        return sc.isUpcastedTimestampTz(isDatasetManaged) || dialect.needCast(sc, isDatasetManaged);
    }

    public static ExpressionBuilder getPartitionFilterClause(String partitioningColumnName, Dataset dataset, List<Partition> partitions, SQLDialect dialect) {
        ExpressionBuilder[] conditions = new ExpressionBuilder[partitions.size()];
        ExpressionBuilder col = ef.col(partitioningColumnName);
        int i = 0;
        for (Partition partition : partitions) {
            ExpressionBuilder pcol = ExpressionUtils.getAdjustedColumn(col, partitioningColumnName, dataset, dialect);
            if (partition.id().equals("sampleval")) {
                conditions[i++] = pcol.eq(ef.srcPartitionId(partitioningColumnName));
                continue;
            }
            conditions[i++] = pcol.eq(ef.cst(partition.id()));
        }
        return ef.or(conditions);
    }

    public static ExpressionBuilder getDstPartitionFilterClause(PartitioningScheme scheme, Dataset dataset, SQLDialect dialect) {
        if (scheme == null || !scheme.isPartitioned()) {
            return null;
        }
        Schema schema = dataset.getSchema();
        ArrayList conditions = Lists.newArrayList();
        for (String dimensionName : scheme.getDimensionNames()) {
            Dimension dimension = scheme.getDimension(dimensionName);
            SchemaColumn dimensionColumn = schema.getColumnOrDefault(dimensionName, Type.STRING);
            ExpressionBuilder value = ef.dstPartitionId(dimensionColumn, dimension);
            conditions.add(ef.col(dimensionName).eq(value));
        }
        return conditions.size() > 0 ? ef.and(conditions.toArray(new ExpressionBuilder[0])) : null;
    }

    public static ExpressionBuilder getPartitionFilterClause(PartitioningScheme scheme, Dataset dataset, List<Partition> partitions, SQLDialect dialect) {
        return ExpressionUtils.getPartitionFilterClause(scheme, dataset.getSchema(), ExpressionUtils.getTimezoneConfig(dataset), partitions, dataset.isManaged(), dialect);
    }

    public static ExpressionBuilder getDeltaFormatPartitionFilterClause(PartitioningScheme scheme, Dataset dataset, List<Partition> partitions, boolean isDatasetManaged) {
        return ExpressionUtils.getDeltaFormatPartitionFilterClause(scheme, dataset.getSchema(), ExpressionUtils.getTimezoneConfig(dataset), partitions, isDatasetManaged);
    }

    public static ExpressionBuilder getPartitionFilterClause(PartitioningScheme scheme, Schema schema, DatasetHandler.DatasetParams config, List<Partition> partitions, boolean isDatasetManaged, SQLDialect dialect) {
        ArrayList conditions = Lists.newArrayList();
        for (Partition partition : partitions) {
            ExpressionBuilder condition = ExpressionUtils.getPartitionFilterClause(scheme, schema, config, partition, isDatasetManaged, dialect);
            if (condition == null) continue;
            conditions.add(condition);
        }
        return conditions.size() > 0 ? ef.or(conditions.toArray(new ExpressionBuilder[0])) : null;
    }

    public static ExpressionBuilder getDeltaFormatPartitionFilterClause(PartitioningScheme scheme, Schema schema, DatasetHandler.DatasetParams config, List<Partition> partitions, boolean isDatasetManaged) {
        ArrayList conditions = Lists.newArrayList();
        for (Partition partition : partitions) {
            ExpressionBuilder condition = ExpressionUtils.getFSLikePartitionFilterClause(scheme, schema, config, partition, isDatasetManaged);
            if (condition == null) continue;
            conditions.add(condition);
        }
        return conditions.size() > 0 ? ef.or(conditions.toArray(new ExpressionBuilder[0])) : null;
    }

    public static String getStringForDimensionValue(DimensionValue value, Type valueType) {
        String valueString = value.id();
        if (valueType.isTemporal() && value instanceof TimeDimensionValue) {
            TimeDimensionValue timeValue = (TimeDimensionValue)value;
            String suffix = switch (valueType) {
                case Type.DATEONLY -> "";
                case Type.DATETIMENOTZ -> " HH:00:00.000";
                default -> "THH:00:00.000Z";
            };
            switch (timeValue.getDimension().mappedPeriod) {
                case YEAR: {
                    return valueString + "-01-01" + suffix.replace("HH", "00");
                }
                case MONTH: {
                    return valueString + "-01" + suffix.replace("HH", "00");
                }
                case DAY: {
                    return valueString + suffix.replace("HH", "00");
                }
                case HOUR: {
                    if (valueString.length() != 13) {
                        throw new QueryUtils.SQLGenerationException("Partition id " + valueString + " doesn't conform to format YYYY-MM-DD-HH");
                    }
                    return valueString.substring(0, 10) + suffix.replace("HH", valueString.substring(11));
                }
            }
            throw new QueryUtils.SQLGenerationException("Cannot convert time partition in " + String.valueOf(timeValue.getDimension().mappedPeriod) + " to SQL");
        }
        return valueString;
    }

    public static ExpressionBuilder getPartitionFilterClause(PartitioningScheme scheme, Dataset dataset, Partition partition, SQLDialect dialect) {
        return ExpressionUtils.getPartitionFilterClause(scheme, dataset.getSchema(), ExpressionUtils.getTimezoneConfig(dataset), partition, dataset.isManaged(), dialect);
    }

    public static ExpressionBuilder getPartitionFilterClause(PartitioningScheme scheme, Schema schema, DatasetHandler.DatasetParams config, Partition partition, boolean isDatasetManaged, SQLDialect dialect) {
        if (partition == null || partition.isAll() || partition.isNP()) {
            return null;
        }
        ArrayList conditions = Lists.newArrayList();
        Map dimensionValues = partition.getDimensionValues();
        for (String dimensionName : scheme.getDimensionNames()) {
            Type valueType;
            if (!dimensionValues.containsKey(dimensionName)) continue;
            if (partition.id().equals("sampleval")) {
                ExpressionBuilder pcol = ExpressionUtils.getPartitionColumnExpression(dimensionName, scheme, schema, config, isDatasetManaged, dialect);
                conditions.add(pcol.eq(ef.srcPartitionId(dimensionName)));
                continue;
            }
            DimensionValue value = (DimensionValue)dimensionValues.get(dimensionName);
            SchemaColumn dimensionColumn = schema.getColumn(dimensionName);
            Type type = valueType = dimensionColumn != null ? dimensionColumn.getType() : Type.STRING;
            if (valueType.isTemporal() && value instanceof TimeDimensionValue) {
                TimeDimensionValue timeValue = (TimeDimensionValue)value;
                conditions.add(ExpressionUtils.makeOneDateCondition(dialect, dimensionName, config, isDatasetManaged, timeValue, dimensionColumn, false));
                continue;
            }
            if (valueType == Type.STRING && value instanceof TimeDimensionValue && !isDatasetManaged && dimensionColumn != null && "date".equalsIgnoreCase(StringUtils.defaultIfBlank((String)dimensionColumn.originalSQLType, (String)dimensionColumn.originalType))) {
                SchemaColumn inferredColumn = new SchemaColumn(dimensionColumn).withType(Type.DATEONLY);
                TimeDimensionValue timeValue = (TimeDimensionValue)value;
                conditions.add(ExpressionUtils.makeOneDateCondition(dialect, dimensionName, config, isDatasetManaged, timeValue, inferredColumn, false));
                continue;
            }
            ExpressionBuilder pcol = ExpressionUtils.getPartitionColumnExpression(dimensionName, scheme, schema, config, isDatasetManaged, dialect);
            conditions.add(ExpressionUtils.makeOneTypedCondition(pcol, value, valueType));
        }
        return conditions.size() > 0 ? ef.and(conditions.toArray(new ExpressionBuilder[0])) : null;
    }

    public static ExpressionBuilder getFSLikePartitionFilterClause(PartitioningScheme scheme, Schema schema, DatasetHandler.DatasetParams config, Partition partition, boolean isDatasetManaged) {
        if (partition == null || partition.isAll() || partition.isNP()) {
            return null;
        }
        ArrayList conditions = Lists.newArrayList();
        Map dimensionValues = partition.getDimensionValues();
        SparkSQLDialect sparkSQLDialect = new SparkSQLDialect();
        for (String dimensionName : scheme.getDimensionNames()) {
            if (!dimensionValues.containsKey(dimensionName)) continue;
            if (partition.id().equals("sampleval")) {
                ExpressionBuilder pcol = ExpressionUtils.getPartitionColumnExpression(dimensionName, scheme, schema, config, isDatasetManaged, sparkSQLDialect);
                conditions.add(pcol.eq(ef.srcPartitionId(dimensionName)));
                continue;
            }
            DimensionValue value = (DimensionValue)dimensionValues.get(dimensionName);
            SchemaColumn dimensionColumn = schema.getColumn(dimensionName);
            if (value instanceof TimeDimensionValue) {
                TimeDimensionValue timeValue = (TimeDimensionValue)value;
                if (dimensionColumn != null) {
                    if (dimensionColumn.getType().isTemporal()) {
                        conditions.add(ExpressionUtils.makeOneDateCondition(sparkSQLDialect, dimensionName, config, isDatasetManaged, timeValue, dimensionColumn, true));
                        continue;
                    }
                    ExpressionBuilder pcol = ExpressionUtils.getPartitionColumnExpression(dimensionName, scheme, schema, config, isDatasetManaged, sparkSQLDialect);
                    conditions.add(ExpressionUtils.makeOneTypedCondition(pcol, value, dimensionColumn.getType()));
                    continue;
                }
                Map<TimeDimension.Period, String> timeNames = FilePartitioner.guessTimePeriodColumnNames(scheme.getFilePathPattern());
                ArrayList timeClauses = Lists.newArrayList();
                for (TimeDimension.Period p : TimeDimension.Period.values()) {
                    SchemaColumn col;
                    String colName = timeNames.get(p);
                    String colValue = timeValue.getPeriodValue(p);
                    logger.info((Object)("For " + String.valueOf(p) + " n=" + colName + " v=" + colValue));
                    if (StringUtils.isBlank((String)colName) || StringUtils.isBlank((String)colValue)) continue;
                    if (colName.indexOf(37) >= 0) {
                        try {
                            colName = new URLCodec().decode(colName, "utf-8");
                            logger.info((Object)("Decoded column name to " + colName));
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Unable to decode patition column name that may be url-encoded: " + colName), (Throwable)e);
                        }
                    }
                    if ((col = schema.getColumn(colName)) != null) {
                        ExpressionBuilder pcol = ExpressionUtils.getPartitionColumnExpression(colName, scheme, schema, config, isDatasetManaged, sparkSQLDialect);
                        timeClauses.add(ExpressionUtils.makeOneTypedCondition(pcol, colValue, col.getType()));
                        continue;
                    }
                    logger.info((Object)("Column " + colName + " not found in schema"));
                }
                TimeDimension dimension = timeValue.getDimension();
                if (dimension.mappedPeriod == TimeDimension.Period.YEAR && timeClauses.size() == 1 || dimension.mappedPeriod == TimeDimension.Period.MONTH && timeClauses.size() == 2 || dimension.mappedPeriod == TimeDimension.Period.DAY && timeClauses.size() == 3 || dimension.mappedPeriod == TimeDimension.Period.HOUR && timeClauses.size() == 4) {
                    conditions.add(ef.and(timeClauses.toArray(new ExpressionBuilder[0])));
                    continue;
                }
                logger.warn((Object)"Unable to convert partition to equality filters");
                continue;
            }
            if (dimensionColumn != null) {
                ExpressionBuilder pcol = ExpressionUtils.getPartitionColumnExpression(dimensionName, scheme, schema, config, isDatasetManaged, sparkSQLDialect);
                conditions.add(ExpressionUtils.makeOneTypedCondition(pcol, value, dimensionColumn.getType()));
                continue;
            }
            throw new IllegalArgumentException("Cannot build partition filter, column '" + dimensionName + "' isn't declared in the data");
        }
        return conditions.size() > 0 ? ef.and(conditions.toArray(new ExpressionBuilder[0])) : null;
    }

    private static ExpressionBuilder makeOneTypedCondition(ExpressionBuilder pcol, DimensionValue value, Type valueType) {
        String valueString = ExpressionUtils.getStringForDimensionValue(value, valueType);
        return ExpressionUtils.makeOneTypedCondition(pcol, valueString, valueType);
    }

    private static ExpressionBuilder makeOneTypedCondition(ExpressionBuilder pcol, String valueString, Type valueType) {
        if (valueType.isNumeric()) {
            if (valueType.isFloatingPoint()) {
                return pcol.eq(Double.parseDouble(valueString));
            }
            return pcol.eq(Long.parseLong(valueString));
        }
        if (valueType == Type.BOOLEAN) {
            if (booleanMeaning.parse(valueString)) {
                return pcol.isTrue();
            }
            return pcol.isFalse();
        }
        return pcol.eq(ef.cst(valueString));
    }

    private static ExpressionBuilder makeOneDateCondition(SQLDialect dialect, String dimensionName, DatasetHandler.DatasetParams config, boolean isDatasetManaged, TimeDimensionValue timeValue, SchemaColumn dimensionColumn, boolean isDeltaPartitionValue) {
        ExpressionBuilder col = ef.col(dimensionName);
        ExpressionBuilder pcol = dialect.getAdjustedColumnForTimeCondition(col, dimensionColumn, config, isDatasetManaged);
        ExpressionBuilder lowerBound = ef.cst((Object)dialect.getStringForTimeDimensionValue(timeValue, dimensionColumn, config, isDatasetManaged), isDeltaPartitionValue);
        ExpressionBuilder upperBound = ef.cst((Object)dialect.getStringForTimeDimensionValue(timeValue.nextPeriod(), dimensionColumn, config, isDatasetManaged), isDeltaPartitionValue);
        if (dimensionColumn != null && dimensionColumn.getType() == Type.DATEONLY) {
            return pcol.gte(lowerBound.cast(Type.DATEONLY)).and(pcol.lt(upperBound.cast(Type.DATEONLY)));
        }
        return pcol.gte(lowerBound).and(pcol.lt(upperBound));
    }

    public static ExpressionBuilder getPartitionColumnExpression(String dimensionName, Dataset dataset, SQLDialect dialect) {
        return ExpressionUtils.getPartitionColumnExpression(dimensionName, dataset.getPartitioningSchema(), dataset.getSchema(), ExpressionUtils.getTimezoneConfig(dataset), dataset.isManaged(), dialect);
    }

    public static ExpressionBuilder getPartitionColumnExpression(String dimensionName, PartitioningScheme scheme, Schema schema, DatasetHandler.DatasetParams config, boolean isDatasetManaged, SQLDialect dialect) {
        Type valueType;
        Dimension dimension = scheme.getDimension(dimensionName);
        ExpressionBuilder col = ef.col(dimensionName);
        ExpressionBuilder pcol = ExpressionUtils.getAdjustedColumn(col, dimensionName, schema, config, isDatasetManaged, dialect);
        SchemaColumn dimensionColumn = schema.getColumn(dimensionName);
        Type type = valueType = dimensionColumn != null ? dimensionColumn.getType() : Type.STRING;
        if (valueType.isTemporal() && dimension instanceof TimeDimension) {
            TimeDimension timeDimension = (TimeDimension)dimension;
            pcol.expr.outputType.dssType = valueType;
            String unit = switch (timeDimension.mappedPeriod) {
                case TimeDimension.Period.YEAR -> DateRounding.YEAR.name();
                case TimeDimension.Period.MONTH -> DateRounding.MONTH.name();
                case TimeDimension.Period.DAY -> DateRounding.DAY.name();
                case TimeDimension.Period.HOUR -> DateRounding.HOUR.name();
                default -> throw new QueryUtils.SQLGenerationException("Cannot convert partition column in " + String.valueOf(timeDimension.mappedPeriod) + " to SQL");
            };
            if (valueType == Type.DATEONLY) {
                return pcol.dateonlyTrunc(unit);
            }
            if (valueType == Type.DATETIMENOTZ) {
                return pcol.datetimenotzTrunc(unit);
            }
            return pcol.dateTrunc(unit);
        }
        return pcol;
    }

    public static ExpressionBuilder diff(ExpressionBuilder e1, ExpressionBuilder e2, Type type, String dateDiffUnit) {
        ExpressionBuilder diff;
        if (type.isTemporal()) {
            String unit = dateDiffUnit != null ? dateDiffUnit : "DAY";
            e1.expr.outputType.dssType = type;
            e2.expr.outputType.dssType = type;
            diff = e1.minusDate(e2, unit);
        } else {
            diff = type == Type.BOOLEAN ? e1.castToInt().minus(e2.castToInt()) : e1.minus(e2);
        }
        return diff;
    }

    public static ExpressionBuilder min(ExpressionBuilder expr, Type type, QueryAst.Window window) {
        ExpressionBuilder min;
        if (type == Type.BOOLEAN) {
            min = expr.castToInt().min();
            if (window != null) {
                min = min.over(window);
            }
            min = min.intToBool();
        } else {
            min = expr.min();
            if (window != null) {
                min = min.over(window);
            }
        }
        return min;
    }

    public static ExpressionBuilder max(ExpressionBuilder expr, Type type, QueryAst.Window window) {
        ExpressionBuilder max;
        if (type == Type.BOOLEAN) {
            max = expr.castToInt().max();
            if (window != null) {
                max = max.over(window);
            }
            max = max.intToBool();
        } else {
            max = expr.max();
            if (window != null) {
                max = max.over(window);
            }
        }
        return max;
    }

    public static void aliasColumns(ExpressionBuilder expr, final String alias) {
        expr.expr.visit(new QueryAst.NodeVisitor(){

            @Override
            public void handle(QueryAst.Node node) {
                if (node instanceof QueryAst.Column) {
                    QueryAst.Column col = (QueryAst.Column)node;
                    col.table = new QueryAst.Table(null, null, alias, alias);
                }
            }
        });
    }
}

