/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.QueryBuilderUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class UpsertQueryBuilder
extends InsertQueryBuilder {
    private final List<String> keyColumnNames = new ArrayList<String>();

    public static UpsertQueryBuilder into(SQLUtils.SQLTable table) {
        return new UpsertQueryBuilder(table);
    }

    private UpsertQueryBuilder(SQLUtils.SQLTable table) {
        super(table);
    }

    @Override
    protected void assertBuilderIsValid() {
        super.assertBuilderIsValid();
        ImmutableList columns = FluentIterable.from((Iterable)this.columns).transform((Function)new Function<SchemaColumn, String>(){

            public String apply(SchemaColumn schemaColumn) {
                return schemaColumn.getName();
            }
        }).toList();
        for (String keyColumnName : this.keyColumnNames) {
            Preconditions.checkState((boolean)columns.contains((Object)keyColumnName), (Object)"Cannot specify a KEY COLUMN that has not been added to the columns of the table: 'MISSING COLUMN'");
        }
    }

    @Override
    protected String toH2() {
        return this.header("MERGE INTO") + " KEY " + QueryBuilderUtils.tuple(this.keyColumnNames, this.dialect) + this.parameterizedValue();
    }

    @Override
    protected String toPostgre() {
        return this.header("INSERT INTO") + this.parameterizedValue() + " ON CONFLICT " + QueryBuilderUtils.tuple(this.keyColumnNames, this.dialect) + " DO UPDATE SET " + this.updateInstructions("EXCLUDED.%s");
    }

    @Override
    protected String toMySQL() {
        return this.header("INSERT INTO") + this.parameterizedValue() + " ON DUPLICATE KEY UPDATE " + this.updateInstructions("VALUES(%s)");
    }

    @Override
    public UpsertQueryBuilder addColumns(SchemaColumn ... columns) {
        for (SchemaColumn column : columns) {
            this.columns.add(new SchemaColumn(column));
        }
        return this;
    }

    @Override
    public UpsertQueryBuilder addColumns(SchemaColumn[] ... columnsGroups) {
        SchemaColumn[][] schemaColumnArray = columnsGroups;
        int n = schemaColumnArray.length;
        for (int i = 0; i < n; ++i) {
            SchemaColumn[] columnGroup;
            for (SchemaColumn column : columnGroup = schemaColumnArray[i]) {
                this.addColumns(column);
            }
        }
        return this;
    }

    public UpsertQueryBuilder addKeyColumns(String ... columns) {
        if (columns != null) {
            this.keyColumnNames.addAll(Arrays.asList(columns));
        }
        return this;
    }

    public UpsertQueryBuilder addKeyColumns(SchemaColumn ... columns) {
        if (columns != null) {
            this.keyColumnNames.addAll(Arrays.stream(columns).map(SchemaColumn::getName).collect(Collectors.toList()));
        }
        return this;
    }

    private Function<SchemaColumn, String> toUpdatedField(final String existingValueAliasPattern) {
        return new Function<SchemaColumn, String>(){

            public String apply(SchemaColumn schemaColumn) {
                String columnName = UpsertQueryBuilder.this.dialect.quoteIdentifier(schemaColumn.getName());
                return columnName + "=" + String.format(existingValueAliasPattern, columnName);
            }
        };
    }

    private String updateInstructions(String existingValueAliasPattern) {
        return this.transformAndJoinSchemaColumns(this.toUpdatedField(existingValueAliasPattern), false);
    }
}

