/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.backend.CommitEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.jgit.DSSGitUtils;
import com.dataiku.dip.transactions.git.jgit.SingleRepositoryGitManager;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class DSSSingleRepositoryGitManager
extends SingleRepositoryGitManager {
    public DSSSingleRepositoryGitManager(File repositoryRoot) throws IOException {
        super(repositoryRoot);
    }

    String getDefaultBranch() {
        return DSSGitUtils.getDefaultBranchUnreliably();
    }

    protected String getPath(String projectKey) {
        return "projects/" + projectKey;
    }

    public String commit(CommitDef def) throws IOException {
        DSSCommitDef commitDef = (DSSCommitDef)def;
        String ret = super.commit((CommitDef)commitDef);
        try {
            if (ret != null) {
                PubSubService pubSub = (PubSubService)((Object)SpringUtils.getBean(PubSubService.class));
                pubSub.publish(new CommitEvent(commitDef.message, commitDef.itemId, commitDef.author, ret));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return ret;
    }
}

